/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.h2;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKTWriter;
import geodb.GeoDB;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.geometry.jts.Geometries;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2Dialect
extends SQLDialect {
    public static String H2_SPATIAL_INDEX = "org.geotools.data.h2.spatialIndex";

    public H2Dialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public String getNameEscape() {
        return "\"";
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        super.registerSqlTypeToClassMappings(mappings);
        mappings.put(new Integer(2004), Geometry.class);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Geometry.class, new Integer(2004));
        mappings.put(Point.class, new Integer(2004));
        mappings.put(LineString.class, new Integer(2004));
        mappings.put(Polygon.class, new Integer(2004));
        mappings.put(GeometryCollection.class, new Integer(2004));
        mappings.put(MultiPoint.class, new Integer(2004));
        mappings.put(MultiLineString.class, new Integer(2004));
        mappings.put(MultiPolygon.class, new Integer(2004));
    }

    public void initializeConnection(Connection cx) throws SQLException {
        GeoDB.InitGeoDB((Connection)cx);
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return !"_GEODB".equals(tableName) && !tableName.endsWith("_HATBOX");
    }

    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        Geometries g;
        String remark = columnMetaData.getString("REMARKS");
        if (remark != null && (g = Geometries.getForName((String)remark)) != null) {
            return g.getBinding();
        }
        return null;
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
        Class binding;
        if (att instanceof GeometryDescriptor && this.isConcreteGeometry(binding = att.getType().getBinding())) {
            sql.append(" COMMENT '").append(binding.getSimpleName().toUpperCase()).append("'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        String tableName = featureType.getTypeName();
        try {
            for (PropertyDescriptor ad : featureType.getDescriptors()) {
                CoordinateReferenceSystem crs;
                if (!(ad instanceof GeometryDescriptor)) continue;
                GeometryDescriptor gd = (GeometryDescriptor)ad;
                Class binding = ad.getType().getBinding();
                String propertyName = ad.getName().getLocalPart();
                if (this.isConcreteGeometry(binding)) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("ALTER TABLE ");
                    this.encodeTableName(tableName, sql);
                    sql.append(" ADD CONSTRAINT ");
                    this.encodeTableName(tableName + "_" + propertyName + "GeometryType", sql);
                    sql.append(" CHECK ");
                    this.encodeColumnName(propertyName, sql);
                    sql.append(" IS NULL OR");
                    sql.append(" GeometryType(");
                    this.encodeColumnName(propertyName, sql);
                    sql.append(") = '").append(Geometries.getForBinding((Class)binding).getName().toUpperCase()).append("'");
                    LOGGER.fine(sql.toString());
                    st.execute(sql.toString());
                }
                if ((crs = gd.getCoordinateReferenceSystem()) == null) continue;
                Integer epsg = null;
                try {
                    epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
                }
                catch (FactoryException e) {
                    LOGGER.log(Level.FINER, "Unable to look epsg code", e);
                }
                if (epsg == null) continue;
                StringBuffer sql = new StringBuffer();
                sql.append("CALL CreateSpatialIndex(");
                if (schemaName == null) {
                    sql.append("NULL");
                } else {
                    sql.append("'").append(schemaName).append("'");
                }
                sql.append(",'").append(tableName).append("'");
                sql.append(",'").append(propertyName).append("'");
                sql.append(",'").append(epsg).append("')");
                LOGGER.fine(sql.toString());
                st.execute(sql.toString());
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateFeatureType(SimpleFeatureType featureType, DatabaseMetaData metadata, String schemaName, Connection cx) throws SQLException {
        if (featureType.getGeometryDescriptor() == null) {
            return;
        }
        String idxTableName = featureType.getTypeName() + "_HATBOX";
        ResultSet rs = metadata.getTables(null, schemaName, idxTableName, new String[]{"TABLE"});
        try {
            if (rs.next()) {
                featureType.getGeometryDescriptor().getUserData().put(H2_SPATIAL_INDEX, idxTableName);
            }
        }
        finally {
            this.dataStore.closeSafe(rs);
        }
    }

    boolean isConcreteGeometry(Class binding) {
        return Point.class.isAssignableFrom(binding) || LineString.class.isAssignableFrom(binding) || Polygon.class.isAssignableFrom(binding) || MultiPoint.class.isAssignableFrom(binding) || MultiLineString.class.isAssignableFrom(binding) || MultiPolygon.class.isAssignableFrom(binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        int srid = GeoDB.GetSRID((Connection)cx, (String)schemaName, (String)tableName);
        if (srid > -1) {
            return srid;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ST_SRID(");
        this.encodeColumnName(columnName, sql);
        sql.append(") ");
        sql.append("FROM ");
        if (schemaName != null) {
            this.encodeTableName(schemaName, sql);
            sql.append(".");
        }
        this.encodeSchemaName(tableName, sql);
        sql.append(" WHERE ");
        this.encodeColumnName(columnName, sql);
        sql.append(" is not null LIMIT 1");
        this.dataStore.getLogger().fine(sql.toString());
        Statement st = cx.createStatement();
        try {
            ResultSet rs;
            block10: {
                Integer n;
                rs = st.executeQuery(sql.toString());
                try {
                    if (!rs.next()) break block10;
                    n = new Integer(rs.getInt(1));
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs);
                    throw throwable;
                }
                this.dataStore.closeSafe(rs);
                return n;
            }
            Integer n = null;
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("ST_Envelope(");
        this.encodeColumnName(geometryColumn, sql);
        sql.append(")");
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        return (Envelope)rs.getObject(column);
    }

    public void encodeGeometryValue(Geometry value, int srid, StringBuffer sql) throws IOException {
        sql.append("ST_GeomFromText ('");
        sql.append(new WKTWriter().write(value));
        sql.append("',");
        sql.append(srid);
        sql.append(")");
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(column);
        if (bytes == null) {
            return null;
        }
        try {
            return new WKBReader(factory).read(bytes);
        }
        catch (ParseException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(column, sql);
        sql.append(" int AUTO_INCREMENT(1) PRIMARY KEY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String sequenceName = tableName + "_" + columnName + "_SEQUENCE";
        sequenceName = sequenceName.toUpperCase();
        Statement st = cx.createStatement();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM INFORMATION_SCHEMA.SEQUENCES ");
            sql.append("WHERE SEQUENCE_NAME = '").append(sequenceName).append("'");
            this.dataStore.getLogger().fine(sql.toString());
            ResultSet rs = st.executeQuery(sql.toString());
            try {
                if (rs.next()) {
                    String string = sequenceName;
                    return string;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            Integer n;
            String sql = "SELECT NEXTVAL('" + sequenceName + "')";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                rs.next();
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            Integer n;
            ResultSet rs = st.executeQuery("SELECT b.COLUMN_DEFAULT  FROM INFORMATION_SCHEMA.INDEXES A, INFORMATION_SCHEMA.COLUMNS B WHERE a.TABLE_NAME = b.TABLE_NAME  AND a.COLUMN_NAME = b.COLUMN_NAME  AND a.TABLE_NAME = '" + tableName + "' " + " AND a.COLUMN_NAME = '" + columnName + "' " + " AND a.PRIMARY_KEY = TRUE");
            String sequence = null;
            try {
                rs.next();
                String string = rs.getString(1);
                sequence = string.substring(string.indexOf("SYSTEM_SEQUENCE"), string.length() - 1);
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
            try {
                rs = schemaName != null ? st.executeQuery("SELECT CURRVAL('" + schemaName + "','" + sequence + "')") : st.executeQuery("SELECT CURRVAL('" + sequence + "')");
                rs.next();
                int value = rs.getInt(1);
                n = new Integer(value + 1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit > 0 && limit < Integer.MAX_VALUE) {
            sql.append(" LIMIT " + limit);
            if (offset > 0) {
                sql.append(" OFFSET " + offset);
            }
        } else if (offset > 0) {
            sql.append(" LIMIT 2147483647");
            sql.append(" OFFSET " + offset);
        }
    }
}

