/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.io.IOException;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.oracle.OracleDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class OracleNGDataStoreFactory
extends JDBCDataStoreFactory {
    private static final String JDBC_PATH = "jdbc:oracle:thin:@";
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"oracle");
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", true, (Object)1521);
    public static final DataAccessFactory.Param LOOSEBBOX = new DataAccessFactory.Param("Loose bbox", Boolean.class, "Perform only primary filter on bbox", false, (Object)Boolean.TRUE);

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new OracleDialect(dataStore);
    }

    protected String getDatabaseID() {
        return (String)OracleNGDataStoreFactory.DBTYPE.sample;
    }

    public String getDisplayName() {
        return "Oracle NG";
    }

    public String getDescription() {
        return "Oracle Database";
    }

    protected String getDriverClassName() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    protected boolean checkDBType(Map params) {
        if (super.checkDBType(params)) {
            try {
                Class.forName("org.geotools.data.oracle.OracleDataStoreFactory");
                return false;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
        return this.checkDBType(params, "Oracle");
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        if (dataStore.getDatabaseSchema() != null) {
            dataStore.setDatabaseSchema(dataStore.getDatabaseSchema().toUpperCase());
        }
        OracleDialect dialect = (OracleDialect)dataStore.getSQLDialect();
        Boolean loose = (Boolean)LOOSEBBOX.lookUp(params);
        dialect.setLooseBBOXEnabled(loose == null || Boolean.TRUE.equals(loose));
        dataStore.setFetchSize(200);
        return dataStore;
    }

    protected String getJDBCUrl(Map params) throws IOException {
        String host = (String)HOST.lookUp(params);
        String db = (String)DATABASE.lookUp(params);
        int port = (Integer)PORT.lookUp(params);
        if (db.startsWith("(")) {
            return JDBC_PATH + db;
        }
        if (db.startsWith("/")) {
            return "jdbc:oracle:thin:@//" + host + ":" + port + db;
        }
        return JDBC_PATH + host + ":" + port + ":" + db;
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.put(OracleNGDataStoreFactory.LOOSEBBOX.key, LOOSEBBOX);
        parameters.put(OracleNGDataStoreFactory.PORT.key, PORT);
        parameters.put(OracleNGDataStoreFactory.DBTYPE.key, DBTYPE);
    }

    protected String getValidationQuery() {
        return "select sysdate from dual";
    }
}

