/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.xmlcodegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDUtil;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.feature.type.SchemaImpl;
import org.geotools.graph.build.basic.BasicDirectedGraphGenerator;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.traverse.GraphIterator;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.GraphWalker;
import org.geotools.graph.traverse.basic.BasicGraphTraversal;
import org.geotools.graph.traverse.standard.DirectedDepthFirstTopologicalIterator;
import org.geotools.graph.util.graph.DirectedCycleDetector;
import org.geotools.maven.xmlcodegen.AbstractGenerator;
import org.geotools.maven.xmlcodegen.GeneratorUtils;
import org.geotools.maven.xmlcodegen.TypeBinding;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Schemas;
import org.geotools.xs.XS;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator
extends AbstractGenerator {
    XSDSchema schema;
    HashMap types;
    FeatureTypeFactory factory;
    boolean simpleTypes;
    boolean complexTypes;
    boolean followComplexTypes;
    HashMap imports;
    Set includes;
    int maxDepth = 15;
    boolean printRecursionPaths = false;
    private Map<Name, String> typeBindings;
    Logger logger = Logging.getLogger((String)"org.geotools.xml");

    public SchemaGenerator(XSDSchema schema) {
        this.schema = schema;
        this.factory = new FeatureTypeFactoryImpl();
        this.types = new HashMap();
        this.simpleTypes = true;
        this.complexTypes = true;
        this.followComplexTypes = true;
        this.imports = new HashMap();
        this.includes = new HashSet();
    }

    public XSDSchema getSchema() {
        return this.schema;
    }

    public void setComplexTypes(boolean complexTypes) {
        this.complexTypes = complexTypes;
    }

    public void setSimpleTypes(boolean simpleTypes) {
        this.simpleTypes = simpleTypes;
    }

    public void setFollowComplexTypes(boolean followComplexTypes) {
        this.followComplexTypes = followComplexTypes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes == null ? Collections.EMPTY_SET : new HashSet<String>(Arrays.asList(includes));
    }

    public void setPrintRecursionPaths(boolean printRecursionPaths) {
        this.printRecursionPaths = printRecursionPaths;
    }

    public void setMaxRecursionDepth(int maxDepth) {
        if (maxDepth > 0) {
            this.maxDepth = maxDepth;
        }
    }

    public void addTypeMapping(String namespace, String name, AttributeType gtType) {
        if (namespace == null) {
            namespace = this.schema.getTargetNamespace();
        }
        assert (name != null);
        EList typeDefs = this.schema.getTypeDefinitions();
        for (XSDTypeDefinition xsdType : typeDefs) {
            String tns = xsdType.getTargetNamespace();
            String tn = xsdType.getName();
            if (!namespace.equals(tns) || !name.equals(tn)) continue;
            this.types.put(xsdType, gtType);
            return;
        }
        throw new IllegalArgumentException("Type: [" + namespace + "," + name + "] not found");
    }

    public void setTypeBindings(TypeBinding[] typeBindings) {
        HashMap<Name, String> bindings = new HashMap<Name, String>();
        if (typeBindings != null) {
            for (TypeBinding typeBinding : typeBindings) {
                String name;
                String namespace = typeBinding.getNamespace();
                if (namespace == null) {
                    namespace = this.schema.getTargetNamespace();
                }
                if ((name = typeBinding.getName()) == null) {
                    throw new IllegalArgumentException("Missing name for typeBinding");
                }
                String binding = typeBinding.getBinding();
                if (binding == null) {
                    throw new IllegalArgumentException("Missing binding for typeBinding for " + name);
                }
                bindings.put((Name)new NameImpl(namespace, name), binding);
            }
        }
        this.typeBindings = bindings;
    }

    public Map<Name, String> getTypeBindings() {
        return this.typeBindings;
    }

    public void addImport(Schema imported) {
        this.imports.put(imported.getURI(), imported);
    }

    public Schema getImport(String namespace) {
        return (Schema)this.imports.get(namespace);
    }

    public Collection getImports() {
        return this.imports.values();
    }

    public XSDTypeDefinition getXSDType(AttributeType type) {
        for (Map.Entry entry : this.types.entrySet()) {
            XSDTypeDefinition xsdType = (XSDTypeDefinition)entry.getKey();
            AttributeType gtType = (AttributeType)entry.getValue();
            if (!gtType.equals(type)) continue;
            return xsdType;
        }
        return null;
    }

    public void generate() throws Exception {
        List typeDefs = GeneratorUtils.types(this.schema, this.includes);
        if (this.simpleTypes) {
            this.logger.info("Generting simple types");
            for (XSDTypeDefinition xsdType : typeDefs) {
                if (xsdType.getName() == null || !xsdType.getTargetNamespace().equals(this.schema.getTargetNamespace()) || !(xsdType instanceof XSDSimpleTypeDefinition)) continue;
                this.logger.info(xsdType.getName());
                this.createType((XSDSimpleTypeDefinition)xsdType, 0);
            }
        }
        if (this.complexTypes) {
            this.logger.info("Generting complex types");
            for (XSDTypeDefinition xsdType : typeDefs) {
                if (xsdType.getName() == null || !xsdType.getTargetNamespace().equals(this.schema.getTargetNamespace()) || !(xsdType instanceof XSDComplexTypeDefinition)) continue;
                this.logger.info(xsdType.getName());
                try {
                    this.createType((XSDComplexTypeDefinition)xsdType, 0);
                }
                catch (Exception e) {
                    this.logger.warning("XERRORX generating " + xsdType);
                }
            }
        }
        SchemaImpl gtSchema = new SchemaImpl(this.schema.getTargetNamespace());
        for (AttributeType gtType : this.types.values()) {
            if (gtType.getName().getLocalPart() == null) {
                throw new NullPointerException();
            }
            gtSchema.put((Object)gtType.getName(), (Object)gtType);
        }
        Object[] input = new Object[]{gtSchema, Schemas.getTargetPrefix((XSDSchema)this.schema), this};
        String result = this.execute("SchemaClassTemplate", input);
        String className = Schemas.getTargetPrefix((XSDSchema)this.schema).toUpperCase() + "Schema";
        this.write(result, className, this.sourceLocation);
    }

    public List sort() {
        BasicDirectedGraphGenerator gg = new BasicDirectedGraphGenerator();
        for (AttributeType type : this.types.values()) {
            AttributeType superType = type.getSuper();
            if (superType != null) {
                gg.add((Object)new Object[]{type, superType});
            }
            if (!(type instanceof ComplexType)) continue;
            ComplexType cType = (ComplexType)type;
            Collection atts = cType.getDescriptors();
            for (PropertyDescriptor ad : atts) {
                gg.add((Object)new Object[]{type, ad.getType()});
            }
        }
        Graph graph = gg.getGraph();
        DirectedCycleDetector cycleDetector = new DirectedCycleDetector(graph);
        if (cycleDetector.containsCycle()) {
            this.logger.info("Cycle found");
            return null;
        }
        DirectedDepthFirstTopologicalIterator iterator = new DirectedDepthFirstTopologicalIterator();
        final ArrayList sorted = new ArrayList();
        GraphWalker walker = new GraphWalker(){

            public int visit(Graphable element, GraphTraversal traversal) {
                AttributeType type = (AttributeType)element.getObject();
                if (type.getName().getNamespaceURI().equals(SchemaGenerator.this.schema.getTargetNamespace())) {
                    sorted.add(element.getObject());
                }
                return 0;
            }

            public void finish() {
            }
        };
        BasicGraphTraversal traversal = new BasicGraphTraversal(graph, walker, (GraphIterator)iterator);
        traversal.init();
        traversal.traverse();
        assert (sorted.size() == this.types.size());
        Collections.reverse(sorted);
        return sorted;
    }

    private AttributeType createType(XSDTypeDefinition xsdType, int depth) {
        if (xsdType instanceof XSDSimpleTypeDefinition) {
            return this.createType((XSDSimpleTypeDefinition)xsdType, depth);
        }
        return this.createType((XSDComplexTypeDefinition)xsdType, depth);
    }

    private AttributeType createType(XSDSimpleTypeDefinition xsdType, int depth) {
        if (this.types.containsKey(xsdType)) {
            return (AttributeType)this.types.get(xsdType);
        }
        if (!xsdType.getTargetNamespace().equals(this.schema.getTargetNamespace())) {
            return this.findType((XSDTypeDefinition)xsdType);
        }
        AttributeType superType = null;
        XSDTypeDefinition baseType = xsdType.getBaseType();
        if (baseType != null && !baseType.equals(xsdType) && baseType.getName() != null) {
            superType = this.createType(baseType, depth + 1);
            assert (superType != null);
        }
        AttributeType gtType = this.factory.createAttributeType(this.name((XSDTypeDefinition)xsdType), Object.class, false, false, Collections.EMPTY_LIST, superType, null);
        this.types.put(xsdType, gtType);
        return gtType;
    }

    private AttributeType createType(XSDComplexTypeDefinition xsdType, int depth) {
        if (depth > this.maxDepth) {
            throw new RuntimeException(xsdType.getName());
        }
        if (this.printRecursionPaths) {
            for (int i = 0; i < depth; ++i) {
                System.out.print("-");
            }
            System.out.println(xsdType.getName());
        }
        if (this.types.containsKey(xsdType)) {
            return (AttributeType)this.types.get(xsdType);
        }
        if (!xsdType.getTargetNamespace().equals(this.schema.getTargetNamespace())) {
            return this.findType((XSDTypeDefinition)xsdType);
        }
        AttributeType superType = null;
        XSDTypeDefinition baseType = xsdType.getBaseType();
        if (baseType != null && !baseType.equals(xsdType) && baseType.getName() != null) {
            superType = this.createType(baseType, depth + 1);
            assert (superType != null);
        }
        ArrayList<AttributeDescriptor> properties = new ArrayList<AttributeDescriptor>();
        if (this.followComplexTypes) {
            String uri;
            AttributeType gtType;
            List children = Schemas.getChildElementParticles((XSDTypeDefinition)xsdType, (boolean)false);
            for (XSDParticle particle : children) {
                XSDTypeDefinition childType;
                XSDElementDeclaration element = (XSDElementDeclaration)particle.getContent();
                if (element.isElementDeclarationReference()) {
                    element = element.getResolvedElementDeclaration();
                }
                if ((childType = element.getTypeDefinition()) == null) {
                    childType = this.findGlobalElementXSDType(element);
                }
                gtType = null;
                gtType = childType != null ? this.createType(childType, depth + 1) : this.xsAnyType();
                assert (gtType != null);
                uri = element.getTargetNamespace();
                String name = element.getName();
                int minOccurs = particle.getMinOccurs();
                int maxOccurs = particle.getMaxOccurs();
                if (maxOccurs == -1) {
                    maxOccurs = Integer.MAX_VALUE;
                }
                boolean isNillable = element.isNillable();
                AttributeDescriptor ad = this.factory.createAttributeDescriptor(gtType, (Name)new NameImpl(uri, name), minOccurs, maxOccurs, isNillable, null);
                properties.add(ad);
            }
            List atts = Schemas.getAttributeDeclarations((XSDTypeDefinition)xsdType, (boolean)false);
            for (XSDAttributeDeclaration attribute : atts) {
                XSDSimpleTypeDefinition type;
                if (attribute.isAttributeDeclarationReference()) {
                    attribute = attribute.getResolvedAttributeDeclaration();
                }
                if ((type = attribute.getTypeDefinition()).getName() == null) continue;
                gtType = this.createType(type, depth + 1);
                if ("uom".equals(attribute.getName())) {
                    System.out.println();
                }
                if ((uri = attribute.getTargetNamespace()) == null) {
                    uri = xsdType.getTargetNamespace();
                }
                AttributeDescriptor ad = this.factory.createAttributeDescriptor(gtType, (Name)new NameImpl(uri, attribute.getName()), 0, 1, true, null);
                properties.add(ad);
            }
        }
        ComplexType gtType = this.factory.createComplexType(this.name((XSDTypeDefinition)xsdType), properties, false, xsdType.isAbstract(), Collections.EMPTY_LIST, superType, null);
        this.types.put(xsdType, gtType);
        return gtType;
    }

    private AttributeType findType(XSDTypeDefinition xsdType) {
        Name name = this.name(xsdType);
        if (this.imports != null) {
            for (Schema imported : this.imports.values()) {
                if (!imported.containsKey((Object)name)) continue;
                return (AttributeType)imported.get((Object)name);
            }
        }
        throw new IllegalStateException("Could not find imported type: " + name);
    }

    private XSDTypeDefinition findGlobalElementXSDType(XSDElementDeclaration element) {
        for (XSDElementDeclaration e : this.schema.getElementDeclarations()) {
            if (!element.getName().equals(e.getName()) || element.getTargetNamespace() != null && !element.getTargetNamespace().equals(e.getTargetNamespace())) continue;
            return e.getType();
        }
        return null;
    }

    private Name name(XSDTypeDefinition type) {
        if (type.getName() == null) {
            System.out.println(type);
        }
        return new NameImpl(type.getTargetNamespace(), type.getName());
    }

    private AttributeType xsAnyType() {
        XSDSchema schema = XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
        for (XSDTypeDefinition t : schema.getTypeDefinitions()) {
            if (!XS.ANYTYPE.getLocalPart().equals(t.getName())) continue;
            return this.findType(t);
        }
        throw new IllegalStateException("XS schema not present");
    }

    public static void main(String[] args) throws Exception {
        XSDSchema schema = XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
        SchemaGenerator generator = new SchemaGenerator(schema);
        generator.setComplexTypes(false);
        generator.setFollowComplexTypes(false);
        generator.setSimpleTypes(true);
        generator.generate();
    }
}

