/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package net.opengis.wcs10.validation;

import net.opengis.gml.CodeListType;

import net.opengis.wcs10.AxisDescriptionType;
import net.opengis.wcs10.AxisDescriptionType1;
import net.opengis.wcs10.ClosureType;
import net.opengis.wcs10.ContentMetadataType;
import net.opengis.wcs10.CoverageDescriptionType;
import net.opengis.wcs10.CoverageOfferingBriefType;
import net.opengis.wcs10.CoverageOfferingType;
import net.opengis.wcs10.DescribeCoverageType;
import net.opengis.wcs10.DomainSetType;
import net.opengis.wcs10.GetCapabilitiesType;
import net.opengis.wcs10.GetCoverageType;
import net.opengis.wcs10.InterpolationMethodType;
import net.opengis.wcs10.IntervalType;
import net.opengis.wcs10.KeywordsType;
import net.opengis.wcs10.LonLatEnvelopeType;
import net.opengis.wcs10.MetadataLinkType;
import net.opengis.wcs10.RangeSetType;
import net.opengis.wcs10.RangeSetType1;
import net.opengis.wcs10.ServiceType;
import net.opengis.wcs10.SpatialDomainType;
import net.opengis.wcs10.SpatialSubsetType;
import net.opengis.wcs10.SupportedCRSsType;
import net.opengis.wcs10.SupportedFormatsType;
import net.opengis.wcs10.SupportedInterpolationsType;
import net.opengis.wcs10.TimePeriodType;
import net.opengis.wcs10.TimeSequenceType;
import net.opengis.wcs10.TypedLiteralType;
import net.opengis.wcs10.WCSCapabilitiesType;
import net.opengis.wcs10.WCSCapabilityType;

import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * A sample validator interface for {@link net.opengis.wcs10.DocumentRoot}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface DocumentRootValidator {
    boolean validate();

    boolean validateMixed(FeatureMap value);
    boolean validateXMLNSPrefixMap(EMap value);
    boolean validateXSISchemaLocation(EMap value);
    boolean validateAxisDescription(AxisDescriptionType1 value);
    boolean validateAxisDescription1(AxisDescriptionType value);
    boolean validateCapability(WCSCapabilityType value);
    boolean validateContentMetadata(ContentMetadataType value);
    boolean validateCoverageDescription(CoverageDescriptionType value);
    boolean validateCoverageOffering(CoverageOfferingType value);
    boolean validateCoverageOfferingBrief(CoverageOfferingBriefType value);
    boolean validateDescribeCoverage(DescribeCoverageType value);
    boolean validateDescription(String value);
    boolean validateDomainSet(DomainSetType value);
    boolean validateFormats(CodeListType value);
    boolean validateGetCapabilities(GetCapabilitiesType value);
    boolean validateGetCoverage(GetCoverageType value);
    boolean validateInterpolationMethod(InterpolationMethodType value);
    boolean validateInterval(IntervalType value);
    boolean validateKeywords(KeywordsType value);
    boolean validateLonLatEnvelope(LonLatEnvelopeType value);
    boolean validateMetadataLink(MetadataLinkType value);
    boolean validateName(String value);
    boolean validateRangeSet(RangeSetType1 value);
    boolean validateRangeSet1(RangeSetType value);
    boolean validateService(ServiceType value);
    boolean validateSingleValue(TypedLiteralType value);
    boolean validateSpatialDomain(SpatialDomainType value);
    boolean validateSpatialSubset(SpatialSubsetType value);
    boolean validateSupportedCRSs(SupportedCRSsType value);
    boolean validateSupportedFormats(SupportedFormatsType value);
    boolean validateSupportedInterpolations(SupportedInterpolationsType value);
    boolean validateTemporalDomain(TimeSequenceType value);
    boolean validateTemporalSubset(TimeSequenceType value);
    boolean validateTimePeriod(TimePeriodType value);
    boolean validateTimeSequence(TimeSequenceType value);
    boolean validateWCSCapabilities(WCSCapabilitiesType value);
    boolean validateClosure(ClosureType value);
    boolean validateSemantic(String value);
    boolean validateType(String value);
}
