/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.kml.bindings;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.geotools.kml.KML;
import org.geotools.xml.AbstractSimpleBinding;
import org.geotools.xml.InstanceComponent;

public class CoordinatesTypeBinding
extends AbstractSimpleBinding {
    CoordinateSequenceFactory csFactory;

    public CoordinatesTypeBinding(CoordinateSequenceFactory csFactory) {
        this.csFactory = csFactory;
    }

    public QName getTarget() {
        return KML.CoordinatesType;
    }

    public Class getType() {
        return CoordinateSequence.class;
    }

    public int getExecutionMode() {
        return 2;
    }

    public Object parse(InstanceComponent instance, Object value) throws Exception {
        List list = (List)value;
        Coordinate[] coordinates = new Coordinate[list.size()];
        int i = 0;
        Iterator l = list.iterator();
        while (l.hasNext()) {
            StringTokenizer st = new StringTokenizer((String)l.next(), ",");
            Coordinate c = new Coordinate();
            c.x = Double.parseDouble(st.nextToken());
            c.y = Double.parseDouble(st.nextToken());
            if (st.hasMoreTokens()) {
                c.z = Double.parseDouble(st.nextToken());
            }
            coordinates[i] = c;
            ++i;
        }
        return this.csFactory.create(coordinates);
    }

    public String encode(Object object, String value) throws Exception {
        StringBuffer sb = new StringBuffer();
        CoordinateSequence cs = (CoordinateSequence)object;
        for (int i = 0; i < cs.size(); ++i) {
            Coordinate c = cs.getCoordinate(i);
            sb.append(c.x).append(",").append(c.y);
            if (cs.getDimension() == 3 && !Double.isNaN(c.z)) {
                sb.append(",").append(c.z);
            }
            sb.append(" ");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

