/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wcs.bindings;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.gml3.GML;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.wcs.WCS;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LonLatEnvelopeBaseTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return WCS.LonLatEnvelopeBaseType;
    }

    public Class<GeneralEnvelope> getType() {
        return GeneralEnvelope.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List positions = node.getChildren("pos");
        if (!positions.isEmpty() && positions.size() == 2) {
            Node n1 = (Node)positions.get(0);
            Node n2 = (Node)positions.get(1);
            GeneralDirectPosition p1 = (GeneralDirectPosition)n1.getValue();
            GeneralDirectPosition p2 = (GeneralDirectPosition)n2.getValue();
            GeneralEnvelope envelope = new GeneralEnvelope(p1, p2);
            if (p1.getDimension() == 2 && p1.getDimension() == 2) {
                envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                return envelope;
            }
            if (p1.getDimension() > 2 && p2.getDimension() > 2) {
                envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D);
                return envelope;
            }
        }
        if (!positions.isEmpty()) {
            throw new RuntimeException("Envelope can have only two coordinates");
        }
        throw new RuntimeException("Could not find coordinates for envelope");
    }

    public int getExecutionMode() {
        return 2;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        GeneralEnvelope envelope = (GeneralEnvelope)object;
        if (envelope == null) {
            value.appendChild(document.createElementNS("http://www.opengis.net/gml", GML.Null.getLocalPart()));
        }
        return null;
    }

    public Object getProperty(Object object, QName name) {
        GeneralEnvelope envelope = (GeneralEnvelope)object;
        if (envelope == null) {
            return null;
        }
        if (name.getLocalPart().equals("srsName")) {
            return "WGS84(DD)";
        }
        if (name.getLocalPart().equals("pos")) {
            CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
            GeographicCRS spatialCRS = null;
            if (crs instanceof CompoundCRS) {
                List CRSs = ((DefaultCompoundCRS)crs).getCoordinateReferenceSystems();
                for (Object item : CRSs) {
                    if (!(item instanceof GeographicCRS)) continue;
                    spatialCRS = (GeographicCRS)item;
                }
            } else {
                spatialCRS = (GeographicCRS)envelope.getCoordinateReferenceSystem();
            }
            if (spatialCRS != null) {
                LinkedList<GeneralDirectPosition> envelopePositions = new LinkedList<GeneralDirectPosition>();
                GeneralDirectPosition lowerCorner = new GeneralDirectPosition(envelope.getCoordinateReferenceSystem());
                GeneralDirectPosition upperCorner = new GeneralDirectPosition(envelope.getCoordinateReferenceSystem());
                int i = 0;
                while (i < spatialCRS.getCoordinateSystem().getDimension()) {
                    lowerCorner.setOrdinate(i, envelope.getLowerCorner().getOrdinate(i));
                    upperCorner.setOrdinate(i, envelope.getUpperCorner().getOrdinate(i));
                    ++i;
                }
                envelopePositions.add(lowerCorner);
                envelopePositions.add(upperCorner);
                return envelopePositions;
            }
        }
        return null;
    }
}

