/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml4wcs.bindings;

import javax.xml.namespace.QName;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.gml4wcs.GML;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.geometry.DirectPosition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectPositionTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return GML.DirectPositionType;
    }

    public Class getType() {
        return DirectPosition.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        GeneralDirectPosition dp = null;
        if ("pos".equals(instance.getName())) {
            String[] CP = instance.getText().split(" ");
            double[] coordinates = new double[CP.length];
            int c = 0;
            for (String coord : CP) {
                coordinates[c++] = Double.parseDouble(coord.trim());
            }
            dp = new GeneralDirectPosition(coordinates);
        }
        return dp;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        DirectPosition dp = (DirectPosition)object;
        if (dp == null) {
            value.appendChild(document.createElementNS("http://www.opengis.net/gml", org.geotools.gml3.GML.Null.getLocalPart()));
        }
        double[] coordinates = dp.getCoordinate();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < coordinates.length; ++i) {
            sb.append(String.valueOf(coordinates[i]));
            if (i == coordinates.length - 1) continue;
            sb.append(" ");
        }
        value.appendChild(document.createTextNode(sb.toString()));
        return null;
    }

    public Object getProperty(Object object, QName name) {
        DirectPosition dp = (DirectPosition)object;
        if (name.getLocalPart().equals("dimension")) {
            return dp.getDimension();
        }
        return null;
    }
}

