/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.identity.FeatureId;

public class CompositeFeatureCollection
extends DataFeatureCollection {
    List collections;

    public CompositeFeatureCollection(List collections) {
        this.collections = collections;
    }

    protected Iterator openIterator() throws IOException {
        return new CompositeIterator();
    }

    public SimpleFeatureType getSchema() {
        return null;
    }

    public ReferencedEnvelope getBounds() {
        return ReferencedEnvelope.reference((Envelope)DataUtilities.bounds((FeatureCollection)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() throws IOException {
        int count = 0;
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                i.next();
                ++count;
            }
        }
        finally {
            this.close(i);
        }
        return count;
    }

    public boolean addAll(Collection arg0) {
        throw new RuntimeException("Can't add to a composite featurecollection; you need to add to one of the constituent collections direclty.");
    }

    public boolean removeAll(Collection arg0) {
        Iterator it = this.collections.iterator();
        boolean result = false;
        while (it.hasNext()) {
            FeatureCollection col = (FeatureCollection)it.next();
            result |= col.removeAll(arg0);
        }
        return result;
    }

    public boolean retainAll(Collection arg0) {
        boolean result = false;
        for (FeatureCollection col : this.collections) {
            result |= col.removeAll(arg0);
        }
        return result;
    }

    public Object[] toArray(Object[] arg0) {
        ArrayList list = new ArrayList();
        Iterator it = this.collections.iterator();
        while (it.hasNext()) {
            FeatureCollection col = (FeatureCollection)it.next();
            Iterator it2 = col.iterator();
            while (it2.hasNext()) {
                list.add(it.next());
            }
            col.close(it2);
        }
        return list.toArray(arg0);
    }

    public FeatureId getIdentifier() {
        throw new RuntimeException("Can't get the id for a composite featurecollection; you need to identify the consituent collections directly.");
    }

    class CompositeIterator
    implements Iterator {
        int index = 0;
        Iterator iterator;

        public void remove() {
        }

        public boolean hasNext() {
            if (this.iterator != null && this.iterator.hasNext()) {
                return true;
            }
            while (this.index < CompositeFeatureCollection.this.collections.size()) {
                if (this.iterator != null) {
                    ((FeatureCollection)CompositeFeatureCollection.this.collections.get(this.index - 1)).close(this.iterator);
                }
                this.iterator = ((FeatureCollection)CompositeFeatureCollection.this.collections.get(this.index++)).iterator();
                if (!this.iterator.hasNext()) continue;
                return true;
            }
            if (this.iterator != null) {
                ((FeatureCollection)CompositeFeatureCollection.this.collections.get(CompositeFeatureCollection.this.collections.size() - 1)).close(this.iterator);
            }
            return false;
        }

        public Object next() {
            return this.iterator.next();
        }
    }
}

