/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.IdClass;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.granite.generator.as3.As3Type;
import org.granite.generator.as3.reflect.JavaBean;
import org.granite.generator.as3.reflect.JavaFieldProperty;
import org.granite.generator.as3.reflect.JavaProperty;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.as3.reflect.JavaTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEntityBean
extends JavaBean {
    protected final List<JavaFieldProperty> identifiers;
    protected final JavaType idClass;
    protected JavaFieldProperty version;
    private Map<String, As3Type> hasMany = new HashMap<String, As3Type>();

    public JavaEntityBean(JavaTypeFactory provider, Class<?> type, URL url) {
        super(provider, type, url);
        ArrayList<JavaFieldProperty> tmpIdentifiers = new ArrayList<JavaFieldProperty>();
        for (JavaProperty property : this.properties.values()) {
            if (!(property instanceof JavaFieldProperty)) continue;
            JavaFieldProperty fieldProperty = (JavaFieldProperty)property;
            if (provider.isId(fieldProperty)) {
                tmpIdentifiers.add(fieldProperty);
                continue;
            }
            if (!provider.isVersion(fieldProperty)) continue;
            this.version = fieldProperty;
        }
        this.identifiers = tmpIdentifiers.isEmpty() ? null : Collections.unmodifiableList(tmpIdentifiers);
        JavaType javaType = this.idClass = type.isAnnotationPresent(IdClass.class) ? provider.getJavaType(type.getAnnotation(IdClass.class).value()) : null;
        if (this.idClass != null) {
            this.addToImports(provider.getJavaImport(this.idClass.getType()));
        }
        for (JavaProperty property : this.properties.values()) {
            Type[] types;
            Class targetEntity;
            OneToMany anno;
            HashMap<String, String> d = new HashMap<String, String>();
            if (property.isAnnotationPresent(OneToMany.class)) {
                anno = property.getAnnotation(OneToMany.class);
                targetEntity = anno.targetEntity();
                types = property.getGenericTypes();
                if (targetEntity == Void.TYPE && types != null && types.length > 0) {
                    targetEntity = (Class)property.getGenericTypes()[0];
                }
                if (targetEntity != Void.TYPE) {
                    this.hasMany.put(property.getName(), this.getProvider().getAs3Type(targetEntity));
                    d.put("association", "oneToMany");
                    if (!"".equals(anno.mappedBy())) {
                        d.put("bidirectional", "true");
                    }
                }
            }
            if (property.isAnnotationPresent(ManyToMany.class)) {
                anno = property.getAnnotation(ManyToMany.class);
                targetEntity = anno.targetEntity();
                types = property.getGenericTypes();
                if (targetEntity == Void.TYPE && types != null && types.length > 0) {
                    targetEntity = (Class)property.getGenericTypes()[0];
                }
                if (targetEntity != Void.TYPE) {
                    this.hasMany.put(property.getName(), this.getProvider().getAs3Type(targetEntity));
                    d.put("association", "manyToMany");
                    if (!"".equals(anno.mappedBy())) {
                        d.put("bidirectional", "true");
                    }
                }
            }
            if (property.isAnnotationPresent(OneToOne.class)) {
                anno = property.getAnnotation(OneToOne.class);
                targetEntity = anno.targetEntity();
                if (targetEntity == Void.TYPE) {
                    targetEntity = property.getType();
                }
                if (targetEntity != Void.TYPE) {
                    d.put("association", "manyToOne");
                }
            }
            if (!property.isAnnotationPresent(ManyToOne.class)) continue;
            anno = property.getAnnotation(ManyToOne.class);
            targetEntity = anno.targetEntity();
            if (targetEntity == Void.TYPE) {
                targetEntity = property.getType();
            }
            if (targetEntity == Void.TYPE) continue;
            d.put("association", "manyToOne");
        }
    }

    public boolean hasIdentifiers() {
        return this.identifiers != null && !this.identifiers.isEmpty();
    }

    public List<JavaFieldProperty> getIdentifiers() {
        return this.identifiers;
    }

    public JavaFieldProperty getFirstIdentifier() {
        return this.identifiers != null ? this.identifiers.get(0) : null;
    }

    public boolean hasIdClass() {
        return this.idClass != null;
    }

    public JavaType getIdClass() {
        return this.idClass;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public JavaFieldProperty getVersion() {
        return this.version;
    }

    public Map<String, As3Type> getHasMany() {
        return this.hasMany;
    }
}

