/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.validation;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tuckey.web.filters.validation.utils.StringUtils;
import org.tuckey.web.filters.validation.utils.WildcardHelper;

public class ServerNameMatcher {
    private static Logger log = LoggerFactory.getLogger(ServerNameMatcher.class);
    private List patterns = new ArrayList();
    WildcardHelper wh = new WildcardHelper();

    public ServerNameMatcher(String options) {
        String[] enableOnHostsArr = options.split(",");
        for (int i = 0; i < enableOnHostsArr.length; ++i) {
            String s = enableOnHostsArr[i];
            if (StringUtils.isBlank(s)) continue;
            String rawPattern = StringUtils.trim(enableOnHostsArr[i]).toLowerCase();
            int[] compiledPattern = this.wh.compilePattern(rawPattern);
            this.patterns.add(compiledPattern);
        }
    }

    public boolean isMatch(String serverName) {
        log.debug("looking for hostname match on current server name " + serverName);
        if (this.patterns == null || StringUtils.isBlank(serverName)) {
            return false;
        }
        serverName = StringUtils.trim(serverName).toLowerCase();
        for (int i = 0; i < this.patterns.size(); ++i) {
            int[] compiledPattern = (int[])this.patterns.get(i);
            if (!this.wh.matchWithNoResults(serverName, compiledPattern)) continue;
            return true;
        }
        return false;
    }
}

