/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus;

import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.omg.CORBA.Any;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.UserException;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.CurrentHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import scs.core.ConnectionDescription;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import scs.core.IReceptacles;
import scs.core.IReceptaclesHelper;
import scs.core.InvalidName;
import tecgraf.openbus.authenticators.Authenticator;
import tecgraf.openbus.authenticators.CertificateAuthenticator;
import tecgraf.openbus.authenticators.LoginPasswordAuthenticator;
import tecgraf.openbus.core.v1_05.access_control_service.Credential;
import tecgraf.openbus.core.v1_05.access_control_service.CredentialHelper;
import tecgraf.openbus.core.v1_05.access_control_service.IAccessControlService;
import tecgraf.openbus.core.v1_05.access_control_service.IAccessControlServiceHelper;
import tecgraf.openbus.core.v1_05.access_control_service.ILeaseProvider;
import tecgraf.openbus.core.v1_05.access_control_service.ILeaseProviderHelper;
import tecgraf.openbus.core.v1_05.registry_service.IRegistryService;
import tecgraf.openbus.core.v1_05.registry_service.IRegistryServiceHelper;
import tecgraf.openbus.core.v1_05.registry_service.ServiceOffer;
import tecgraf.openbus.exception.ACSLoginFailureException;
import tecgraf.openbus.exception.ACSUnavailableException;
import tecgraf.openbus.exception.CORBAException;
import tecgraf.openbus.exception.InvalidCredentialException;
import tecgraf.openbus.exception.OpenBusException;
import tecgraf.openbus.exception.OpenbusAlreadyInitializedException;
import tecgraf.openbus.exception.PKIException;
import tecgraf.openbus.exception.ServiceUnavailableException;
import tecgraf.openbus.fault_tolerance.v1_05.IFaultTolerantService;
import tecgraf.openbus.fault_tolerance.v1_05.IFaultTolerantServiceHelper;
import tecgraf.openbus.interceptors.ClientInitializer;
import tecgraf.openbus.interceptors.CredentialValidationPolicy;
import tecgraf.openbus.interceptors.FTClientInitializer;
import tecgraf.openbus.interceptors.ServerInitializer;
import tecgraf.openbus.lease.LeaseExpiredCallback;
import tecgraf.openbus.lease.LeaseRenewer;
import tecgraf.openbus.session_service.v1_05.ISessionService;
import tecgraf.openbus.session_service.v1_05.ISessionServiceHelper;
import tecgraf.openbus.util.Log;
import tecgraf.openbus.util.Utils;

public final class Openbus {
    private static final int INVALID_PORT = -1;
    private static final int INVALID_CREDENTIAL_SLOT = -1;
    private static Openbus instance;
    private ORB orb;
    private POA rootPOA;
    private static final String ORB_INITIALIZER_PROPERTY_NAME_PREFIX = "org.omg.PortableInterceptor.ORBInitializerClass.";
    private String host;
    private int port;
    private IAccessControlService acs;
    private ILeaseProvider lp;
    private IFaultTolerantService ft;
    private IComponent ic;
    private LeaseRenewer leaseRenewer;
    private LeaseExpiredCallback leaseExpiredCallback;
    private IRegistryService rgs;
    private ISessionService ss;
    private Credential credential;
    private ThreadLocal<Credential> threadLocalCredential;
    private int requestCredentialSlot;
    private boolean isFaultToleranceEnable;
    private Map<String, Set<String>> ifaceMap;
    private CredentialValidationPolicy credentialValidationPolicy;
    private Policy timeOutPolicy;

    public void fetchACS() throws ACSUnavailableException, CORBAException {
        this.ic = Utils.fetchAccessControlServiceComponent(this.orb, this.host, this.port);
        Object obj = this.ic.getFacet(IAccessControlServiceHelper.id());
        this.acs = IAccessControlServiceHelper.narrow((Object)obj);
        obj = this.ic.getFacet(ILeaseProviderHelper.id());
        this.lp = ILeaseProviderHelper.narrow((Object)obj);
        if (this.isFaultToleranceEnable) {
            obj = this.ic.getFacet(IFaultTolerantServiceHelper.id());
            this.ft = IFaultTolerantServiceHelper.narrow((Object)obj);
            this.acs._set_policy_override(new Policy[]{this.timeOutPolicy}, SetOverrideType.ADD_OVERRIDE);
            this.lp._set_policy_override(new Policy[]{this.timeOutPolicy}, SetOverrideType.ADD_OVERRIDE);
            this.ic._set_policy_override(new Policy[]{this.timeOutPolicy}, SetOverrideType.ADD_OVERRIDE);
            this.ft._set_policy_override(new Policy[]{this.timeOutPolicy}, SetOverrideType.ADD_OVERRIDE);
        }
    }

    private Openbus() {
        this.reset();
    }

    public static Openbus getInstance() {
        if (instance == null) {
            instance = new Openbus();
        }
        return instance;
    }

    public void init(String[] args, Properties props, String host, int port) throws UserException, OpenbusAlreadyInitializedException {
        this.init(args, props, host, port, CredentialValidationPolicy.ALWAYS);
    }

    public void init(String[] args, Properties props, String host, int port, CredentialValidationPolicy policy) throws UserException, OpenbusAlreadyInitializedException {
        if (this.orb != null) {
            throw new OpenbusAlreadyInitializedException();
        }
        if (host == null) {
            throw new IllegalArgumentException("O campo 'host' n\u00e3o pode ser null");
        }
        if (port < 0) {
            throw new IllegalArgumentException("O campo 'port' n\u00e3o pode ser negativo.");
        }
        this.host = host;
        this.port = port;
        if (props == null) {
            throw new IllegalArgumentException("O campo 'props' n\u00e3o pode ser null");
        }
        String clientInitializerClassName = ClientInitializer.class.getName();
        props.put(ORB_INITIALIZER_PROPERTY_NAME_PREFIX + clientInitializerClassName, clientInitializerClassName);
        String serverInitializerClassName = ServerInitializer.class.getName();
        props.put(ORB_INITIALIZER_PROPERTY_NAME_PREFIX + serverInitializerClassName, serverInitializerClassName);
        this.credentialValidationPolicy = policy;
        this.addInterceptedMethods();
        this.orb = ORB.init((String[])args, (Properties)props);
        Object obj = this.orb.resolve_initial_references("RootPOA");
        this.rootPOA = POAHelper.narrow((Object)obj);
        POAManager manager = this.rootPOA.the_POAManager();
        manager.activate();
    }

    public void initWithFaultTolerance(String[] args, Properties props, String host, int port, CredentialValidationPolicy policy) throws UserException, OpenbusAlreadyInitializedException {
        if (this.orb != null) {
            throw new OpenbusAlreadyInitializedException();
        }
        if (host == null) {
            throw new IllegalArgumentException("O campo 'host' n\u00e3o pode ser null");
        }
        if (port < 0) {
            throw new IllegalArgumentException("O campo 'port' n\u00e3o pode ser negativo.");
        }
        if (props == null) {
            throw new IllegalArgumentException("O campo 'props' n\u00e3o pode ser null");
        }
        this.host = host;
        this.port = port;
        this.isFaultToleranceEnable = true;
        this.credentialValidationPolicy = policy;
        this.addInterceptedMethods();
        String clientInitializerClassName = FTClientInitializer.class.getName();
        props.put(ORB_INITIALIZER_PROPERTY_NAME_PREFIX + clientInitializerClassName, clientInitializerClassName);
        String serverInitializerClassName = ServerInitializer.class.getName();
        props.put(ORB_INITIALIZER_PROPERTY_NAME_PREFIX + serverInitializerClassName, serverInitializerClassName);
        props.setProperty("jacorb.connection.client.connect_timeout", "1000");
        props.setProperty("jacorb.retries", "36");
        props.setProperty("jacorb.retry_interval", "5");
        props.setProperty("jacorb.poa.check_reply_end_time", "on");
        int totalTimeOut = 180000;
        this.orb = ORB.init((String[])args, (Properties)props);
        Object obj = this.orb.resolve_initial_references("RootPOA");
        this.rootPOA = POAHelper.narrow((Object)obj);
        POAManager manager = this.rootPOA.the_POAManager();
        manager.activate();
        this.timeOutPolicy = new RelativeRoundtripTimeoutPolicy((long)(totalTimeOut * 10000));
    }

    public void initWithFaultTolerance(String[] args, Properties props, String host, int port) throws UserException, OpenbusAlreadyInitializedException {
        this.initWithFaultTolerance(args, props, host, port, CredentialValidationPolicy.ALWAYS);
    }

    public ORB getORB() {
        return this.orb;
    }

    public POA getRootPOA() {
        return this.rootPOA;
    }

    public void run() {
        this.orb.run();
    }

    public void shutdown(boolean force) {
        this.orb.shutdown(!force);
    }

    public IAccessControlService getAccessControlService() {
        return this.acs;
    }

    public IRegistryService getRegistryService() {
        if (this.rgs != null) {
            return this.rgs;
        }
        if (this.ic == null) {
            return null;
        }
        Object objRecep = this.ic.getFacetByName("IReceptacles");
        IReceptacles ireceptacle = IReceptaclesHelper.narrow((Object)objRecep);
        try {
            ConnectionDescription[] connections = ireceptacle.getConnections("RegistryServiceReceptacle");
            if (connections.length > 0) {
                Object objRef = connections[0].objref;
                IComponent registryComponent = IComponentHelper.narrow((Object)objRef);
                Object objReg = registryComponent.getFacetByName("IRegistryService_v1_05");
                this.rgs = IRegistryServiceHelper.narrow((Object)objReg);
                if (this.isFaultToleranceEnable) {
                    this.rgs._set_policy_override(new Policy[]{this.timeOutPolicy}, SetOverrideType.ADD_OVERRIDE);
                }
            }
        }
        catch (InvalidName e) {
            Log.COMMON.severe("N\u00e3o foi poss\u00edvel obter o servi\u00e7o de registro.", e);
        }
        return this.rgs;
    }

    public ISessionService getSessionService() {
        if (this.ss == null) {
            IRegistryService rgs = this.getRegistryService();
            if (rgs == null) {
                return null;
            }
            ServiceOffer[] offers = rgs.find(new String[]{"ISessionService_v1_05"});
            if (offers.length > 0) {
                IComponent component = offers[0].member;
                Object facet = component.getFacet(ISessionServiceHelper.id());
                if (facet == null) {
                    return null;
                }
                this.ss = ISessionServiceHelper.narrow((Object)facet);
                return this.ss;
            }
            return null;
        }
        return this.ss;
    }

    public Credential getCredential() {
        Credential threadCredential = this.threadLocalCredential.get();
        if (threadCredential != null) {
            return threadCredential;
        }
        return this.credential;
    }

    public void setThreadCredential(Credential credential) {
        this.threadLocalCredential.set(credential);
    }

    public void setInterceptedCredentialSlot(int interceptedCredentialSlot) {
        this.requestCredentialSlot = interceptedCredentialSlot;
    }

    public Credential getInterceptedCredential() {
        try {
            Current pic = CurrentHelper.narrow((Object)this.orb.resolve_initial_references("PICurrent"));
            Any requestCredentialValue = pic.get_slot(this.requestCredentialSlot);
            if (requestCredentialValue.type().kind().equals(TCKind.tk_null)) {
                return null;
            }
            Credential requestCredential = CredentialHelper.extract((Any)requestCredentialValue);
            return requestCredential;
        }
        catch (UserException e) {
            Log.COMMON.severe("Erro ao obter a credencial da requisi\u00e7\u00e3o,", e);
            return null;
        }
    }

    public synchronized IRegistryService connect(String user, String password) throws ACSLoginFailureException, ACSUnavailableException, ServiceUnavailableException, InvalidCredentialException, CORBAException, OpenBusException {
        if (user == null || password == null) {
            throw new IllegalArgumentException("Os par\u00e2metros 'user' e 'password' n\u00e3o podem ser nulos.");
        }
        LoginPasswordAuthenticator authenticator = new LoginPasswordAuthenticator(user, password);
        return this.connect(authenticator);
    }

    public synchronized IRegistryService connect(String name, RSAPrivateKey privateKey, X509Certificate acsCertificate) throws ACSLoginFailureException, ServiceUnavailableException, PKIException, ACSUnavailableException, InvalidCredentialException, OpenBusException, CORBAException {
        if (name == null || privateKey == null || acsCertificate == null) {
            throw new IllegalArgumentException("Nenhum par\u00e2metro pode ser nulo.");
        }
        CertificateAuthenticator authenticator = new CertificateAuthenticator(name, privateKey, acsCertificate);
        return this.connect(authenticator);
    }

    private IRegistryService connect(Authenticator authenticator) throws ACSLoginFailureException, OpenBusException {
        if (this.credential == null) {
            if (this.acs == null) {
                this.fetchACS();
            }
            this.credential = authenticator.authenticate(this.acs);
            if (this.credential != null) {
                this.leaseRenewer = new LeaseRenewer(this.credential, this.lp, new OpenbusExpiredCallback());
                this.leaseRenewer.start();
                return this.getRegistryService();
            }
            throw new ACSLoginFailureException("N\u00e3o foi poss\u00edvel conectar ao barramento.");
        }
        throw new ACSLoginFailureException("O barramento j\u00e1 est\u00e1 conectado.");
    }

    public IRegistryService connect(Credential credential) throws InvalidCredentialException, OpenBusException, ServiceUnavailableException, ACSUnavailableException, CORBAException {
        if (credential == null) {
            throw new IllegalArgumentException("O par\u00e2metro 'credential' n\u00e3o pode ser nulo.");
        }
        if (this.acs == null) {
            this.fetchACS();
        }
        this.credential = credential;
        if (this.acs.isValid(this.credential)) {
            return this.getRegistryService();
        }
        throw new InvalidCredentialException(new NO_PERMISSION("Credencial inv\u00e1lida."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean disconnect() {
        if (this.credential != null) {
            try {
                this.leaseRenewer.stop();
                this.acs.logout(this.credential);
            }
            finally {
                this.leaseRenewer = null;
                this.credential = null;
            }
            return true;
        }
        return false;
    }

    public void destroy() {
        if (this.orb != null) {
            this.orb.destroy();
        }
        this.reset();
        this.orb = null;
        this.rootPOA = null;
        this.host = null;
        this.port = -1;
        this.leaseExpiredCallback = null;
        this.isFaultToleranceEnable = false;
    }

    private void reset() {
        this.acs = null;
        this.rgs = null;
        this.lp = null;
        this.ft = null;
        this.ic = null;
        this.ss = null;
        this.credential = null;
        this.threadLocalCredential = new ThreadLocal();
        this.leaseRenewer = null;
        this.requestCredentialSlot = -1;
        this.ifaceMap = new HashMap<String, Set<String>>();
    }

    public boolean isConnected() {
        return this.credential != null;
    }

    public void setLeaseExpiredCallback(LeaseExpiredCallback lec) {
        this.leaseExpiredCallback = lec;
    }

    public void removeLeaseExpiredCallback() {
        this.leaseExpiredCallback = null;
    }

    public void setInterceptable(String iface, String method, boolean interceptable) {
        Set<String> methods = this.ifaceMap.get(iface);
        if (interceptable) {
            if (methods != null) {
                methods.remove(method);
                if (methods.size() == 0) {
                    this.ifaceMap.remove(iface);
                }
            }
        } else {
            if (methods == null) {
                methods = new HashSet<String>();
                this.ifaceMap.put(iface, methods);
            }
            methods.add(method);
        }
    }

    public boolean isInterceptable(String iface, String method) {
        String corbaObjRepID;
        ArrayList<Set<String>> methodsList = new ArrayList<Set<String>>();
        Set<String> methods = this.ifaceMap.get(iface);
        if (methods != null) {
            methodsList.add(methods);
        }
        if ((methods = this.ifaceMap.get(corbaObjRepID = "org.omg.CORBA.Object")) != null) {
            methodsList.add(methods);
        }
        for (Set set : methodsList) {
            if (!set.contains(method)) continue;
            return false;
        }
        return true;
    }

    public boolean isFaultToleranceEnable() {
        return this.isFaultToleranceEnable;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int hostPort) {
        this.port = hostPort;
    }

    public ILeaseProvider getLeaseProvider() {
        return this.lp;
    }

    public IFaultTolerantService getACSFaultTolerantService() {
        return this.ft;
    }

    public IComponent getACSIComponent() {
        return this.ic;
    }

    public CredentialValidationPolicy getCredentialValidationPolicy() {
        return this.credentialValidationPolicy;
    }

    private void addInterceptedMethods() {
        this.setInterceptable("org.omg.CORBA.Object", "_non_existent", false);
    }

    private void leaseExpired() {
        Log.LEASE.fine("Atualizando estado do Openbus");
        this.reset();
        if (this.leaseExpiredCallback != null) {
            this.leaseExpiredCallback.expired();
        }
    }

    class OpenbusExpiredCallback
    implements LeaseExpiredCallback {
        OpenbusExpiredCallback() {
        }

        @Override
        public void expired() {
            Openbus.this.leaseExpired();
        }
    }
}

