/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interceptors;

import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.util.CorbaLoc;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ForwardRequest;
import tecgraf.openbus.FaultToleranceManager;
import tecgraf.openbus.Openbus;
import tecgraf.openbus.core.v1_05.registry_service.IRegistryService;
import tecgraf.openbus.exception.ACSUnavailableException;
import tecgraf.openbus.exception.CORBAException;
import tecgraf.openbus.interceptors.ClientInterceptor;
import tecgraf.openbus.util.LoadLog;
import tecgraf.openbus.util.Log;

class FTClientInterceptor
extends ClientInterceptor {
    private static final String ACCESS_CONTROL_SERVICE_KEY = "ACS_v1_05";
    private static final String LEASE_PROVIDER_KEY = "LP_v1_05";
    private static final String FAULT_TOLERANT_ACS_KEY = "FTACS_v1_05";
    private static final String REGISTRY_SERVICE_KEY = "RS_v1_05";
    public static final LoadLog LOAD_TEST = new LoadLog("openbus.loadtest");
    private long start;
    private FaultToleranceManager ftManager = FaultToleranceManager.getInstance();

    FTClientInterceptor(Codec codec) {
        super(codec);
        Log.INTERCEPTORS.info("[FTClientInterceptor] INTERCEPTADOR CRIADO!");
    }

    @Override
    public void receive_reply(ClientRequestInfo ri) {
        String key = this.getObjectKey(ri);
        String loadMsg = "receive_reply; --; ; " + (System.currentTimeMillis() - this.start) + "; " + key + "; " + ri.operation();
        LOAD_TEST.info(loadMsg);
        this.ftManager.resetCurrTrial();
    }

    @Override
    public void send_request(ClientRequestInfo ri) {
        String key = this.getObjectKey(ri);
        this.start = System.currentTimeMillis();
        String loadMsg = "send_request; inicio; 0; " + key + "; " + ri.operation();
        LOAD_TEST.info(loadMsg);
        super.send_request(ri);
        loadMsg = "send_request; fim; ; " + (System.currentTimeMillis() - this.start) + "; " + key + "; " + ri.operation();
        LOAD_TEST.info(loadMsg);
    }

    @Override
    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        boolean fetch;
        Log.INTERCEPTORS.fine("[receive_exception] TRATANDO EXCECAO ENVIADA DO SERVIDOR: " + ri.received_exception_id());
        String key = this.getObjectKey(ri);
        String loadMsg = "receive_exception; inicio; ; " + (System.currentTimeMillis() - this.start) + "; " + key + "; " + ri.operation() + "; " + ri.received_exception_id();
        LOAD_TEST.severe(loadMsg);
        String msg = "";
        boolean bl = fetch = ri.received_exception_id().equals("IDL:omg.org/CORBA/TRANSIENT:1.0") || ri.received_exception_id().equals("IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0") || ri.received_exception_id().equals("IDL:omg.org/CORBA/COMM_FAILURE:1.0") || ri.received_exception_id().equals("IDL:omg.org/CORBA/TIMEOUT:1.0") || ri.received_exception_id().equals("IDL:omg.org/CORBA/NO_RESPONSE:1.0") || ri.received_exception_id().equals("IDL:omg.org/CORBA/NO_RESOURCES:1.0") || ri.received_exception_id().equals("IDL:omg.org/CORBA/NO_MEMORY:1.0") || ri.received_exception_id().equals("IDL:omg.org/CORBA/INTERNAL:1.0");
        if (!fetch) {
            Log.INTERCEPTORS.severe(ri.received_exception_id());
            return;
        }
        Openbus bus = Openbus.getInstance();
        if (key.equals("openbus_v1_05") || key.equals(ACCESS_CONTROL_SERVICE_KEY) || key.equals(LEASE_PROVIDER_KEY) || key.equals(FAULT_TOLERANT_ACS_KEY)) {
            while (fetch) {
                if (this.ftManager.updateACSHostInUse()) {
                    bus.setHost(this.ftManager.getACSHostInUse().getHostName());
                    bus.setPort(this.ftManager.getACSHostInUse().getHostPort());
                    try {
                        bus.fetchACS();
                        loadMsg = "receive_exception; fim; ; " + (System.currentTimeMillis() - this.start) + "; " + key + "; " + ri.operation() + "; " + ri.received_exception_id();
                        LOAD_TEST.severe(loadMsg);
                        if (key.equals(ACCESS_CONTROL_SERVICE_KEY)) {
                            throw new ForwardRequest((Object)bus.getAccessControlService());
                        }
                        if (key.equals(LEASE_PROVIDER_KEY)) {
                            throw new ForwardRequest((Object)bus.getLeaseProvider());
                        }
                        if (key.equals("openbus_v1_05")) {
                            throw new ForwardRequest((Object)bus.getACSIComponent());
                        }
                        if (!key.equals(FAULT_TOLERANT_ACS_KEY)) continue;
                        throw new ForwardRequest((Object)bus.getACSFaultTolerantService());
                    }
                    catch (ACSUnavailableException e) {
                        fetch = true;
                        msg = e.getMessage();
                        continue;
                    }
                    catch (CORBAException e) {
                        fetch = true;
                        msg = e.getMessage();
                        continue;
                    }
                }
                fetch = false;
            }
            loadMsg = "receive_exception; fim; ; " + (System.currentTimeMillis() - this.start) + "; " + key + "; " + ri.operation() + "; " + ri.received_exception_id();
            LOAD_TEST.severe(loadMsg);
            Log.INTERCEPTORS.info("[receive_exception][ACSUnavailableException] " + msg);
        } else if (key.equals(REGISTRY_SERVICE_KEY)) {
            IRegistryService rs = bus.getRegistryService();
            loadMsg = "receive_exception; fim; ; " + (System.currentTimeMillis() - this.start) + "; " + key + "; " + ri.operation() + "; " + ri.received_exception_id();
            LOAD_TEST.severe(loadMsg);
            throw new ForwardRequest((Object)rs);
        }
    }

    @Override
    public void receive_other(ClientRequestInfo ri) {
        Log.INTERCEPTORS.fine("[receive_other] TRATANDO OUTRA RESPOSTA!");
        String key = this.getObjectKey(ri);
        String loadMsg = "receive_other; --; ; " + (System.currentTimeMillis() - this.start) + "; " + key + "; " + ri.operation();
        LOAD_TEST.severe(loadMsg);
    }

    public String getObjectKey(ClientRequestInfo ri) {
        Openbus bus = Openbus.getInstance();
        ORB orb = bus.getORB();
        ParsedIOR pior = new ParsedIOR((org.jacorb.orb.ORB)orb, orb.object_to_string(ri.target()));
        String key = CorbaLoc.parseKey((byte[])pior.get_object_key());
        return key;
    }
}

