/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interceptors;

import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import tecgraf.openbus.Openbus;
import tecgraf.openbus.access_control_service.CredentialWrapper;
import tecgraf.openbus.core.v1_05.access_control_service.Credential;
import tecgraf.openbus.core.v1_05.access_control_service.CredentialHelper;
import tecgraf.openbus.interceptors.InterceptorImpl;
import tecgraf.openbus.util.Log;

class ServerInterceptor
extends InterceptorImpl
implements ServerRequestInterceptor {
    private int credentialSlot;

    ServerInterceptor(Codec codec, int credentialSlot) {
        super("ServerInterceptor", codec);
        this.credentialSlot = credentialSlot;
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) {
        String interceptedOperation = ri.operation();
        Log.INTERCEPTORS.info(String.format("Opera\u00e7\u00e3o {%s} interceptada no servidor.", interceptedOperation));
        Openbus bus = Openbus.getInstance();
        bus.setInterceptedCredentialSlot(this.credentialSlot);
        ServiceContext serviceContext = null;
        try {
            serviceContext = ri.get_request_service_context(1234);
        }
        catch (BAD_PARAM e) {
            Log.INTERCEPTORS.info(String.format("Opera\u00e7\u00e3o '%s' n\u00e3o possui credencial", interceptedOperation));
            return;
        }
        if (serviceContext == null) {
            Log.INTERCEPTORS.severe("N\u00e3o h\u00e1 informa\u00e7\u00e3o de contexto (transporte de credencial)");
            return;
        }
        try {
            byte[] value = serviceContext.context_data;
            Credential credential = CredentialHelper.extract((Any)this.getCodec().decode_value(value, CredentialHelper.type()));
            CredentialWrapper wrapper = new CredentialWrapper(credential);
            Log.INTERCEPTORS.info("Credencial: " + wrapper);
            ORB orb = bus.getORB();
            Any credentialValue = orb.create_any();
            CredentialHelper.insert((Any)credentialValue, (Credential)credential);
            ri.set_slot(this.credentialSlot, credentialValue);
        }
        catch (Exception e) {
            Log.INTERCEPTORS.severe("Falha na valida\u00e7\u00e3o da credencial", e);
        }
    }

    public void receive_request(ServerRequestInfo ri) {
    }

    public void send_reply(ServerRequestInfo ri) {
    }

    public void send_exception(ServerRequestInfo ri) {
    }

    public void send_other(ServerRequestInfo ri) {
    }
}

