/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.util;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import tecgraf.openbus.exception.ACSUnavailableException;
import tecgraf.openbus.exception.CORBAException;
import tecgraf.openbus.util.CryptoUtils;
import tecgraf.openbus.util.Log;

public final class Utils {
    public static final String OPENBUS_KEY = "openbus_v1_05";
    public static final String OB_VERSION = "1_05";
    public static final String OB_PREV = "1_04";
    public static final String RECEPTACLES_NAME = "IReceptacles";
    public static final String REGISTRY_SERVICE_RECEPTACLE_NAME = "RegistryServiceReceptacle";
    public static final String REGISTRY_SERVICE_FACET_NAME = "IRegistryService_v1_05";
    public static final String SESSION_SERVICE_FACET_NAME = "ISessionService_v1_05";
    public static final String SESSION_INTERFACE = "IDL:tecgraf/openbus/session_service/v1_05/ISession:1.0";
    public static final String SESSION_FACET_NAME = "ISession_v1_05";
    public static final String SESSION_ES_INTERFACE = "IDL:tecgraf/openbus/session_service/v1_05/SessionEventSink:1.0";
    public static final String SESSION_EVENT_SINK_FACET_NAME = "SessionEventSink_v1_05";
    public static final String FACETS_PROPERTY_NAME = "facets";
    public static final String COMPONENT_ID_PROPERTY_NAME = "component_id";

    public static IComponent fetchAccessControlServiceComponent(ORB orb, String host, int port) throws ACSUnavailableException, CORBAException {
        Log.COMMON.info("Buscando...  corbaloc::1.0@" + host + ":" + port + "/" + OPENBUS_KEY);
        Object obj = orb.string_to_object("corbaloc::1.0@" + host + ":" + port + "/" + OPENBUS_KEY);
        if (obj == null) {
            throw new ACSUnavailableException();
        }
        try {
            if (obj._non_existent()) {
                throw new ACSUnavailableException();
            }
        }
        catch (TRANSIENT te) {
            throw new ACSUnavailableException();
        }
        catch (OBJECT_NOT_EXIST e) {
            throw new ACSUnavailableException();
        }
        catch (COMM_FAILURE ce) {
            throw new ACSUnavailableException();
        }
        catch (SystemException e) {
            throw new CORBAException(e);
        }
        return IComponentHelper.narrow((Object)obj);
    }

    public static byte[] generateAnswer(byte[] challenge, PrivateKey privateKey, Certificate acsCertificate) throws GeneralSecurityException {
        byte[] plainChallenge = CryptoUtils.decrypt(privateKey, challenge);
        return CryptoUtils.encrypt(acsCertificate, plainChallenge);
    }
}

