/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interceptors;

import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import tecgraf.openbus.Openbus;
import tecgraf.openbus.access_control_service.CredentialWrapper;
import tecgraf.openbus.core.v1_05.access_control_service.Credential;
import tecgraf.openbus.core.v1_05.access_control_service.IAccessControlService;
import tecgraf.openbus.util.Log;

final class CredentialValidatorServerInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static CredentialValidatorServerInterceptor instance;

    private CredentialValidatorServerInterceptor() {
    }

    public static CredentialValidatorServerInterceptor getInstance() {
        if (instance == null) {
            instance = new CredentialValidatorServerInterceptor();
        }
        return instance;
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        boolean isValid;
        String method;
        String repID;
        Openbus bus = Openbus.getInstance();
        boolean isInterceptable = bus.isInterceptable(repID = ri.target_most_derived_interface(), method = ri.operation());
        if (!isInterceptable) {
            Log.INTERCEPTORS.info(String.format("Opera\u00e7\u00e3o '%s' n\u00e3o interceptada no servidor.", method));
            return;
        }
        Credential interceptedCredential = bus.getInterceptedCredential();
        if (interceptedCredential == null) {
            Log.INTERCEPTORS.warning("Nenhuma credencial foi interceptada.");
            throw new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
        }
        CredentialWrapper wrapper = new CredentialWrapper(interceptedCredential);
        Log.INTERCEPTORS.info("Credencial interceptada: " + wrapper);
        if (interceptedCredential == null) {
            throw new NO_PERMISSION(100, CompletionStatus.COMPLETED_NO);
        }
        IAccessControlService acs = bus.getAccessControlService();
        try {
            isValid = acs.isValid(interceptedCredential);
        }
        catch (SystemException e) {
            Log.INTERCEPTORS.severe("Erro ao tentar validar uma credencial.", e);
            throw new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
        }
        if (!isValid) {
            Log.INTERCEPTORS.warning("A credencial interceptada " + wrapper + " n\u00e3o \u00e9 v\u00e1lida.");
            throw new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
        }
        Log.INTERCEPTORS.info("A credencial interceptada " + wrapper + " \u00e9 v\u00e1lida.");
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_reply(ServerRequestInfo ri) {
    }

    public void destroy() {
    }

    public String name() {
        return CredentialValidatorServerInterceptor.class.getName();
    }
}

