/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interceptors;

import org.omg.CORBA.LocalObject;
import org.omg.CORBA.UserException;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import tecgraf.openbus.Openbus;
import tecgraf.openbus.interceptors.CachedCredentialValidatorServerInterceptor;
import tecgraf.openbus.interceptors.CodecFactory;
import tecgraf.openbus.interceptors.CredentialValidationPolicy;
import tecgraf.openbus.interceptors.CredentialValidatorServerInterceptor;
import tecgraf.openbus.interceptors.ServerInterceptor;
import tecgraf.openbus.util.Log;

public class ServerInitializer
extends LocalObject
implements ORBInitializer {
    public void post_init(ORBInitInfo info) {
        try {
            info.add_server_request_interceptor((ServerRequestInterceptor)new ServerInterceptor(CodecFactory.createCodec(info), info.allocate_slot_id()));
            Log.INTERCEPTORS.info("REGISTREI INTERCEPTADOR SERVIDOR!");
            Openbus bus = Openbus.getInstance();
            CredentialValidationPolicy policy = bus.getCredentialValidationPolicy();
            if (policy == null) {
                Log.INTERCEPTORS.warning("N\u00e3o foi escolhida nenhuma pol\u00edtica para a valida\u00e7\u00e3o de credenciais obtidas pelo interceptador servidor.");
            } else {
                switch (policy) {
                    case ALWAYS: {
                        info.add_server_request_interceptor((ServerRequestInterceptor)CredentialValidatorServerInterceptor.getInstance());
                        break;
                    }
                    case CACHED: {
                        info.add_server_request_interceptor((ServerRequestInterceptor)CachedCredentialValidatorServerInterceptor.getInstance());
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        Log.INTERCEPTORS.warning("N\u00e3o foi escolhida nenhuma pol\u00edtica para a valida\u00e7\u00e3o de credenciais obtidas pelo interceptador servidor.");
                    }
                }
            }
        }
        catch (UserException e) {
            Log.INTERCEPTORS.severe("ERRO NO REGISTRO DO INTERCEPTADOR SERVIDOR!", e);
        }
    }

    public void pre_init(ORBInitInfo info) {
    }
}

