/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.lease;

import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import tecgraf.openbus.core.v1_05.access_control_service.Credential;
import tecgraf.openbus.core.v1_05.access_control_service.ILeaseProvider;
import tecgraf.openbus.lease.LeaseExpiredCallback;
import tecgraf.openbus.util.Log;

public final class LeaseRenewer {
    private static final String RENEWER_THREAD_NAME = "RenewerThread";
    private static final int DEFAULT_LEASE = 30;
    private RenewerTask renewer;
    private Thread renewerThread;

    public LeaseRenewer(Credential credential, ILeaseProvider leaseProvider, LeaseExpiredCallback expiredCallback) {
        this.renewer = new RenewerTask(credential, leaseProvider, expiredCallback);
    }

    public void setProvider(ILeaseProvider leaseProvider) {
        this.renewer.provider = leaseProvider;
    }

    public void setLeaseExpiredCallback(LeaseExpiredCallback lec) {
        this.renewer.expiredCallback = lec;
    }

    public synchronized void start() {
        if (this.renewerThread != null) {
            this.stop();
        }
        this.renewerThread = new Thread((Runnable)this.renewer, RENEWER_THREAD_NAME);
        this.renewerThread.setDaemon(true);
        this.renewerThread.start();
    }

    public synchronized void stop() {
        if (this.renewerThread != null) {
            this.renewer.finish();
            this.renewerThread.interrupt();
            this.renewerThread = null;
        }
    }

    private static class RenewerTask
    implements Runnable {
        private Credential credential;
        private boolean mustContinue;
        ILeaseProvider provider;
        LeaseExpiredCallback expiredCallback;

        RenewerTask(Credential credential, ILeaseProvider provider) {
            this.credential = credential;
            this.provider = provider;
            this.mustContinue = true;
        }

        RenewerTask(Credential credential, ILeaseProvider provider, LeaseExpiredCallback expiredCallback) {
            this(credential, provider);
            this.expiredCallback = expiredCallback;
        }

        public void run() {
            int lease = 30;
            while (this.mustContinue) {
                IntHolder newLease = new IntHolder();
                try {
                    boolean expired;
                    try {
                        expired = !this.provider.renewLease(this.credential, newLease);
                    }
                    catch (NO_PERMISSION ne) {
                        expired = true;
                    }
                    if (expired) {
                        Log.LEASE.warning("Falha na renova\u00e7\u00e3o da credencial.");
                        this.mustContinue = false;
                        if (this.expiredCallback != null) {
                            Log.LEASE.info("Chamando a callback de expira\u00e7\u00e3o do lease.");
                            this.expiredCallback.expired();
                        }
                    } else {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Lease renovado. Pr\u00f3xima renova\u00e7\u00e3o em ");
                        msg.append(newLease.value);
                        msg.append(" segundos.");
                        Log.LEASE.fine(msg.toString());
                        lease = newLease.value;
                    }
                }
                catch (SystemException e) {
                    Log.LEASE.severe(e.getMessage(), e);
                }
                if (!this.mustContinue) continue;
                try {
                    Thread.sleep(lease * 1000);
                }
                catch (InterruptedException interruptedException) {}
            }
            Log.LEASE.info("Finalizando a renova\u00e7\u00e3o do lease.");
        }

        public void finish() {
            this.mustContinue = false;
        }
    }
}

