/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Log
extends Logger {
    public static final Log SERVICES = new Log("openbus.services");
    public static final Log COMMON = new Log("openbus.common");
    public static final Log LEASE = new Log("openbus.common.lease");
    public static final Log INTERCEPTORS = new Log("openbus.common.interceptors");

    private Log(String name) {
        super(name, null);
        this.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(LogFormatter.getInstance());
        this.addHandler(consoleHandler);
    }

    public static void setLogsLevel(Level newLevel) {
        SERVICES.setLogLevel(newLevel);
        COMMON.setLogLevel(newLevel);
        LEASE.setLogLevel(newLevel);
        INTERCEPTORS.setLogLevel(newLevel);
    }

    private void setLogLevel(Level newLevel) {
        this.setLevel(newLevel);
        Handler[] handlers = this.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].setLevel(newLevel);
        }
    }

    public void severe(String msg, Throwable thrown) {
        this.log(Level.SEVERE, msg, thrown);
    }

    private static class LogFormatter
    extends Formatter {
        private static LogFormatter instance;
        private SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM HH:mm:ss");

        private LogFormatter() {
        }

        static LogFormatter getInstance() {
            if (instance == null) {
                instance = new LogFormatter();
            }
            return instance;
        }

        public String format(LogRecord record) {
            StringBuilder message = new StringBuilder();
            message.append("[");
            message.append(record.getLoggerName());
            message.append(" ");
            message.append(record.getLevel());
            message.append("]");
            message.append(" ");
            Date recordDate = new Date(record.getMillis());
            message.append(this.dateFormatter.format(recordDate));
            message.append("\n");
            message.append(this.formatMessage(record));
            message.append("\n");
            Throwable t = record.getThrown();
            if (t != null) {
                message.append("Exce\u00e7\u00e3o: ");
                message.append(LogFormatter.format(t));
            }
            for (int i = 0; i < 80; ++i) {
                message.append("=");
            }
            message.append("\n");
            return message.toString();
        }

        private static String format(Throwable t) {
            StringBuilder message = new StringBuilder();
            message.append(t.getClass().getName());
            message.append(": ");
            if (t.getMessage() != null) {
                message.append(t.getMessage().trim());
            }
            message.append("\n");
            for (StackTraceElement element : t.getStackTrace()) {
                message.append("==> ");
                message.append(element.getClassName());
                message.append(".");
                message.append(element.getMethodName());
                message.append(" (");
                if (element.isNativeMethod()) {
                    message.append("M\u00e9todo Nativo");
                } else {
                    String fileName = element.getFileName();
                    if (fileName == null) {
                        message.append("Desconhecido");
                    } else {
                        message.append(fileName);
                        int lineNumber = element.getLineNumber();
                        if (lineNumber > 0) {
                            message.append(":");
                            message.append(lineNumber);
                        }
                    }
                }
                message.append(")\n");
            }
            if (t.getCause() != null && t.getCause() != t) {
                message.append("Causada por: ");
                message.append(LogFormatter.format(t.getCause()));
            }
            return message.toString();
        }
    }
}

