package tecgraf.openbus.browser.scs_offers;

import java.lang.ref.WeakReference;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

/**
 * Tipo de n da rvore que representa uma requisio de carregamento de filhos
 * ainda em andamento. Este n  instanciado, e depois removido automaticamente,
 * por ns que estendam {@link AsyncExpandableTreeNode}.
 * <p>
 * Aqui se guarda e exibe o estado do carregamento, para reportar ao usurio.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
final class AsyncExpandableLoadingNodeBean implements NodeWithDetailsInterface, NodeWithIconsInterface {
	private long startTimestamp;
	private String description;
	private WeakReference<AsyncExpandableLoadingDetailsPanel> detailsPanel = null;

	public AsyncExpandableLoadingNodeBean(long startTimestamp, String description) {
		super();
		this.startTimestamp = startTimestamp;
		this.description = description;
	}

	public long getStartTimestamp() {
		return startTimestamp;
	}

	public String getDescription() {
		return description;
	}

	public void setStartTimestamp(long startTimestamp) {
		this.startTimestamp = startTimestamp;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Override
	public String toString() {
		return "Carregando...";
	}

	@Override
	public JPanel getDetailsPanel() {
		AsyncExpandableLoadingDetailsPanel res = null;
		if (detailsPanel != null)
			res = detailsPanel.get();

		if (res == null) {
			res = new AsyncExpandableLoadingDetailsPanel(this);
			detailsPanel = new WeakReference<AsyncExpandableLoadingDetailsPanel>(res);
		}

		return res;
	}

	private static final ImageIcon icon = new ImageIcon(OfferRegistryPanel.class.getResource("hourglass.png"));

	@Override
	public Icon getClosedIcon() {
		return icon;
	}

	@Override
	public Icon getLeafIcon() {
		return icon;
	}

	@Override
	public Icon getOpenedIcon() {
		return icon;
	}

}