package tecgraf.openbus.browser.scs_offers;

import tecgraf.openbus.Connection;
import tecgraf.openbus.browser.scs_offers.basic_nodes.FacetNodeBean;
import tecgraf.openbus.browser.scs_offers.data_service.HDataServiceNodeBean;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalNavigationDataServiceHelper;

/**
 * Convenincia para centralizar a instanciao de ns de facetas ofertadas
 * para que, dependendo da interface implementada pela faceta, eventualmente
 * um n de tipo especial possa ser usado.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
final class FacetNodeBeanFactory {

	/**
	 * Instanciar o n referente  faceta, avaliando o tipo de faceta para
	 * eventualmente construir ns especiais.
	 * @param tree Referncia  rvore para propagao
	 * @param cnn Conexo Openbus a ser usada para propagao
	 * @param facetBean Possivelmente uma faceta cujo n ser inserido na rvore
	 * @return Instncia do n que ser inserido.
	 */
	public static final NodeWithTreeReference getBeanNode(SCSTree tree, Connection cnn, Object facetBean) {

		if (facetBean instanceof FacetNodeBean) {
			return getNodeByFacetNodeBean(tree, cnn, (FacetNodeBean) facetBean);
		}
		else {
			return new NodeWithTreeReference(tree, facetBean);
		}

	}

	/**
	 * Instanciar o n referente  faceta, avaliando o tipo de faceta para
	 * eventualmente construir ns especiais.
	 * @param tree Referncia  rvore para propagao
	 * @param cnn Conexo Openbus a ser usada para propagao
	 * @param facetBean Faceta cujo n ser inserido na rvore
	 * @return Instncia do n que ser inserido.
	 */
	private static NodeWithTreeReference getNodeByFacetNodeBean(SCSTree tree, Connection cnn,
	  FacetNodeBean facetBean) {

		if (facetBean.getFacetDescription().interface_name.equals(IHierarchicalNavigationDataServiceHelper.id())) {
			return new HDataServiceNodeBean(tree, cnn, facetBean);
		}

		return new NodeWithTreeReference(tree, facetBean);
	}

}
