package tecgraf.openbus.browser.scs_offers;

/**
 * Instncia do callback usado para que o componente da rvore interfira
 * programaticamente na mesma interface visual que o usurio utiliza para
 * definir os critrios da busca.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
public interface FindServicesQueryControlInterface {
	/**
	 * Adicionar um novo par chave-valor de propriedade
	 * na interface que define o critrio de busca.
	 * @param property Chave da propriedade.
	 * @param value Valor esperado.
	 */
	public void addCriteria(String property, String value);
	
	/**
	 * Indicar se as ofertas devero ser carregadas inicialmente na rvore
	 * de forma expandida ou se, caso falso, apenas os componentes aparecero.
	 * @return true para expandir at o nvel das ofertas.
	 */
	public boolean isOffersDefaultExpanded();
	
}
