package tecgraf.openbus.browser.scs_offers;

import javax.swing.Icon;

/**
 * Interface a ser implementada pelos ns para que sejam exibidos com
 * cones prprios.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
public interface NodeWithIconsInterface {
	
	/**
	 * Recupera cone para quando o n  folha
	 * @return Instncia de cone
	 */
	public Icon getLeafIcon();

	/**
	 * Recupera cone para quando o n no  folha, e est fechado.
	 * @return Instncia de cone
	 */
	public Icon getOpenedIcon();

	/**
	 * Recupera o cone para quando o n no  folha, e est expandido.
	 * @return Instncia de cone
	 */
	public Icon getClosedIcon();
}
