package tecgraf.openbus.browser.scs_offers;

import javax.swing.tree.DefaultMutableTreeNode;

/**
 * Convenincia para que os ns da rvore possuam uma referncia
 * para o SCSTree ao qual pertencem.
 * 
 * <p>
 * A, ento, ao invs de extender {@link DefaultMutableTreeNode},
 * os ns extendem esta classe.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
@SuppressWarnings("serial")
public class NodeWithTreeReference extends DefaultMutableTreeNode {

	private final SCSTree myTree;

	public NodeWithTreeReference(SCSTree myTree) {
		super();
		this.myTree = myTree;
	}

	public NodeWithTreeReference(SCSTree myTree, Object userObject, boolean allowsChildren) {
		super(userObject, allowsChildren);
		this.myTree = myTree;
	}

	public NodeWithTreeReference(SCSTree myTree, Object userObject) {
		super(userObject);
		this.myTree = myTree;
	}

	/**
	 * @return the myTree
	 */
	public SCSTree getMyTree() {
		return myTree;
	}

}
