package tecgraf.openbus.browser.scs_offers;

import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.DropMode;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;

import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.scs_offers.basic_nodes.ServiceOfferNode;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;

/**
 * JTree que ir representar os componentes e ofertas encontrados no servio de
 * ofertas.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
@SuppressWarnings("serial")
public final class SCSTree extends JTree {

	private final SCSTreeAndDetailsComponent parentComponent;

	protected SCSTree(SCSTreeAndDetailsComponent parentComponent) {

		this.parentComponent = parentComponent;
		setModel(new DefaultTreeModel(null));
		setShowsRootHandles(true);
		setEditable(false);
		setExpandsSelectedPaths(true);
		setRootVisible(false);
		getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);

		addTreeSelectionListener(getTreeSelectionListener());
		addMouseListener(getPopupNodesMouseListener());

		setCellRenderer(new OfferTreeCellRenderer());

		SCSTreeHandler handler = new SCSTreeHandler(this);
		addKeyListener(handler);
		setDropTarget(new DropTarget(this, DnDConstants.ACTION_COPY_OR_MOVE, handler, true));
		setDragEnabled(true);
		setDropMode(DropMode.ON);

		setTransferHandler(new SCSTreeTransferHandle());
		
	}

	private MouseListener getPopupNodesMouseListener() {
		return new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {

				if (SwingUtilities.isRightMouseButton(e)) {
					e.consume();

					NodeWithPopupMenuInterface popuper = null;
					if (getSelectionPath() != null) {
						if (getSelectionPath().getLastPathComponent() instanceof NodeWithPopupMenuInterface) {
							popuper = (NodeWithPopupMenuInterface) getSelectionPath().getLastPathComponent();
						}
						else {
							DefaultMutableTreeNode node = (DefaultMutableTreeNode) getSelectionPath().getLastPathComponent();
							if (node.getUserObject() != null && node.getUserObject() instanceof NodeWithPopupMenuInterface)
								popuper = (NodeWithPopupMenuInterface) node.getUserObject();
						}
					}

					if (popuper != null) {
						JPopupMenu menu = popuper.getPopupMenu();
						if (menu != null) {
							menu.show(e.getComponent(), e.getX(), e.getY());
						}
					}
				}
			}
		};
	}

	private TreeSelectionListener getTreeSelectionListener() {
		return new TreeSelectionListener() {
			@Override
			public void valueChanged(TreeSelectionEvent e) {
				if (e.getNewLeadSelectionPath() == null) {
					parentComponent.setDetails(null);
					return;
				}

				Object[] path = e.getNewLeadSelectionPath().getPath();
				boolean found = false;
				for (int i = path.length - 1; i >= 0; i -= 1) {
					DefaultMutableTreeNode node = (DefaultMutableTreeNode) path[i];
					if (node.getUserObject() instanceof NodeWithDetailsInterface) {
						NodeWithDetailsInterface nodeWithDetails = (NodeWithDetailsInterface) node.getUserObject();
						parentComponent.setDetails(nodeWithDetails.getDetailsPanel());
						found = true;
						break;
					}
				}
				if (!found) {
					parentComponent.setDetails(null);
				}
			}
		};
	}

	/**
	 * Remover o n da rvore informado, notificando a remoo de uma oferta.
	 * 
	 * @param serviceOfferNode Oferta a ser removida da rvore.
	 */
	public void removeOffer(ServiceOfferNode serviceOfferNode) {
		parentComponent.removeOffer(serviceOfferNode);
	}

	protected void addServiceOffer(ManagedConnection cnn, ServiceOfferDesc service, NodeWithTreeReference root) {
		parentComponent.addServiceOffer(cnn, service, root);
	}

}
