package tecgraf.openbus.browser.scs_offers.basic_nodes;

import java.lang.ref.WeakReference;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

import tecgraf.openbus.browser.scs_offers.NodeWithDetailsInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithIconsInterface;
import tecgraf.openbus.browser.scs_offers.OfferRegistryPanel;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;

/**
 * Tipo de n que representa um erro no carregamento dos detalhes do n.
 * Pode ser uma falha de rede ou do componente remoto.
 * 
 * A idia  que este n exiba a mensagem e, no painel de detalhes, exiba
 * a pilha de exceo que provocou o erro relacionado.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
public final class ErrorNodeBean implements NodeWithDetailsInterface, NodeWithIconsInterface {

	private final Throwable myError;
	private WeakReference<ErrorNodeDetailsPanel> detailsPanel = null;

	public ErrorNodeBean(Throwable error) {
		this.myError = error;
	}

	@Override
	public String toString() {
		StringBuilder res = new StringBuilder();
		res.append(myError.getClass().getSimpleName());
		String msg = null;
		if (myError instanceof ServiceFailure) {
			msg = ((ServiceFailure) myError).message;
		}
		else
			msg = myError.getMessage();

		if (msg != null && !msg.trim().isEmpty()) {
			res.append(": ");
			res.append(msg);
		}

		return myError.getClass().getSimpleName();
	}

	@Override
	public JPanel getDetailsPanel() {
		ErrorNodeDetailsPanel res = null;
		if (detailsPanel != null)
			res = detailsPanel.get();
		if (res == null) {
			res = new ErrorNodeDetailsPanel(myError);
			detailsPanel = new WeakReference<ErrorNodeDetailsPanel>(res);
		}
		return res;
	}

	private static final ImageIcon icon = new ImageIcon(OfferRegistryPanel.class.getResource("error.png"));

	@Override
	public Icon getClosedIcon() {
		return null;
	}

	@Override
	public Icon getLeafIcon() {
		return icon;
	}

	@Override
	public Icon getOpenedIcon() {
		return null;
	}

}
