package tecgraf.openbus.browser.scs_offers.basic_nodes;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import org.omg.CORBA.ORB;

import scs.core.FacetDescription;
import scs.core.FacetDescriptionHelper;
import tecgraf.openbus.Connection;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.TipPanelInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithHelpTipInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithIconsInterface;
import tecgraf.openbus.browser.scs_offers.OfferRegistryPanel;

/**
 * Tipo de n que representa uma faceta dentro de um componente SCS.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
public final class FacetNodeBean implements NodeWithIconsInterface, Transferable, NodeWithHelpTipInterface {

	private final FacetDescription facetDescription;
	private final Connection cnn;
	private final DataFlavor myInterfaceFlavor;

	public static final class TransferableFacetDescription implements Serializable {
		private static final long serialVersionUID = 820908851647708819L;
		public final String name;
		public final String interface_name;
		public final String ior;

		public TransferableFacetDescription(ORB orb, FacetDescription facetDescription) {
			super();
			this.name = facetDescription.name;
			this.interface_name = facetDescription.interface_name;
			this.ior = orb.object_to_string(facetDescription.facet_ref);
		}
	}

	public FacetNodeBean(Connection cnn, FacetDescription facetDescription) {
		super();
		this.cnn = cnn;
		this.facetDescription = facetDescription;
		this.myInterfaceFlavor = new DataFlavor(TransferableFacetDescription.class, facetDescription.interface_name);
	}

	/**
	 * @return the facetDescription
	 */
	public final FacetDescription getFacetDescription() {
		return facetDescription;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result =
		  prime * result
		    + ((facetDescription == null) ? 0 : facetDescription.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof FacetNodeBean)) {
			return false;
		}
		FacetNodeBean other = (FacetNodeBean) obj;
		if (facetDescription == null) {
			if (other.facetDescription != null) {
				return false;
			}
		}
		else if (!facetDescription.interface_name.equals(other.facetDescription.interface_name)) {
			return false;
		}
		else if (!facetDescription.name.equals(other.facetDescription.name)) {
			return false;
		}
		return true;
	}

	@Override
	public String toString() {
		return facetDescription.name + "(" + facetDescription.interface_name + ")";
	}

	private static final ImageIcon icon = new ImageIcon(OfferRegistryPanel.class.getResource("port.png"));

	@Override
	public Icon getClosedIcon() {
		return icon;
	}

	@Override
	public Icon getLeafIcon() {
		return icon;
	}

	@Override
	public Icon getOpenedIcon() {
		return icon;
	}

	public static final DataFlavor FACET_DESCRIPTION_DATA_FLAVOR = new DataFlavor(TransferableFacetDescription.class,
	  FacetDescriptionHelper.id());

	@Override
	public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
		if (FACET_DESCRIPTION_DATA_FLAVOR.equals(flavor) || myInterfaceFlavor.equals(flavor)) {
			ManagedConnection.setContextCurrentConnection(cnn);
			return new TransferableFacetDescription(cnn.orb(), facetDescription);
		}

		if (DataFlavor.getTextPlainUnicodeFlavor().equals(flavor)) {
			ManagedConnection.setContextCurrentConnection(cnn);
			return new ByteArrayInputStream(cnn.orb().object_to_string(facetDescription.facet_ref)
			  .getBytes(Charset.forName(DataFlavor.getTextPlainUnicodeFlavor().getParameter("charset"))));
		}

		throw new UnsupportedFlavorException(flavor);
	}

	@Override
	public DataFlavor[] getTransferDataFlavors() {
		return new DataFlavor[] { FACET_DESCRIPTION_DATA_FLAVOR, myInterfaceFlavor, DataFlavor.getTextPlainUnicodeFlavor() };
	}

	@Override
	public boolean isDataFlavorSupported(DataFlavor flavor) {
		return FACET_DESCRIPTION_DATA_FLAVOR.equals(flavor) || myInterfaceFlavor.equals(flavor)
		  || DataFlavor.getTextPlainUnicodeFlavor().equals(flavor);
	}

	@Override
	public void configureHelpTip(TipPanelInterface tipPanel) {
		tipPanel.setTips(new String[] {
		    "Para conectar uma faceta a um receptculo, voc pode arrastar o n da rvore " +
		      "da faceta desejada at o n deste receptculo.",

		    "Para conectar uma faceta  este receptculo, voc pode \"copiar e colar\" n da rvore " +
		      "da faceta desejada no n deste receptculo.",

		    "Para desconectar uma faceta, selecione-a na lista de conexes acima e digite [DEL].",

		    "Para desconectar uma faceta, selecione-a na lista de conexes acima e clique com o boto direito.",

		    "Tecle [F5] para recarregar a lista de conexes deste receptculo do componente.",

		    "Se voc copiar (ctrl+c) o n da faceta e col-lo em uma caixa de texto, voc obter o IOR do objeto remoto."
		}, new String[] {});
	}

}
