package tecgraf.openbus.browser.scs_offers.basic_nodes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.TreeMap;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;

import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;

import tecgraf.openbus.Connection;
import tecgraf.openbus.browser.AsyncObservable;
import tecgraf.openbus.browser.AsyncSwingObserver;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.SlowRequester;
import tecgraf.openbus.browser.TipPanelInterface;
import tecgraf.openbus.browser.AsyncObservable.AsyncObserver;
import tecgraf.openbus.browser.SlowRequester.SlowRunnable;
import tecgraf.openbus.browser.scs_offers.FindServicesQueryControlInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithDetailsInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithHelpTipInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithIconsInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithPopupMenuInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithSearchCapability;
import tecgraf.openbus.browser.scs_offers.NodeWithTreeReference;
import tecgraf.openbus.browser.scs_offers.OfferRegistryPanel;
import tecgraf.openbus.browser.scs_offers.RefreshableNode;
import tecgraf.openbus.browser.scs_offers.SCSTree;
import tecgraf.openbus.browser.scs_offers.ServiceOfferManagedBean;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;

/**
 * Tipo especial de n que representa uma oferta de servio.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
@SuppressWarnings("serial")
public final class ServiceOfferNode extends NodeWithTreeReference implements NodeWithDetailsInterface,
  NodeWithIconsInterface, RefreshableNode,
  NodeWithPopupMenuInterface, NodeWithHelpTipInterface, NodeWithSearchCapability {

	private final ServiceOfferDesc serviceOffer;
	private String label;
	private final Connection cnn;
	private WeakReference<ServiceOfferNodeDetailsPanel> detailsPanel = null;
	private final FindServicesQueryControlInterface queryPropertiesInterface;
	private ServiceOfferManagedBean offerBean;

	private final AsyncObserver offerObserver = new AsyncSwingObserver() {
		@Override
		public void eventInEDT(AsyncObservable src) {
			if (ServiceOfferNode.this.getRoot() != ServiceOfferNode.this.getMyTree().getModel().getRoot())
				return;
			ServiceOfferManagedBean offerBean = (ServiceOfferManagedBean) src;
			if (offerBean.isRemoved()) {
				getMyTree().removeOffer(ServiceOfferNode.this);
			}
			else {
				try {
					label = buildLabel();
					((DefaultTreeModel) getMyTree().getModel()).nodeChanged(ServiceOfferNode.this);
					
					if (offerBean.isInvalid()){
						removeAllChildren();
						((DefaultTreeModel) getMyTree().getModel()).nodeStructureChanged(ServiceOfferNode.this);
					}
					
					((ServiceOfferNodeDetailsPanel) getDetailsPanel()).refresh();
				}
				catch (Exception e) {
					e.printStackTrace(System.err);
				}
			}
		}
	};

	public ServiceOfferNode(SCSTree tree, FindServicesQueryControlInterface queryPropertiesInterface,
	  Connection cnn,
	  ServiceOfferDesc serviceOffer) {
		super(tree);
		this.queryPropertiesInterface = queryPropertiesInterface;
		this.cnn = cnn;
		this.serviceOffer = serviceOffer;
		this.label = buildLabel();
	}

	@Override
	public void refreshNode() throws Exception {
		offerBean.ping();
	}

	/**
	 * @return the serviceOffer
	 */
	public final ServiceOfferDesc getServiceOffer() {
		return serviceOffer;
	}

	/**
	 * @return the label
	 */
	public final String getLabel() {
		return label;
	}

	private String buildLabel() {
		
		if (offerBean != null && offerBean.isTesting())
			return "Testando oferta...";
		
		TreeMap<String, String> propsMap = new TreeMap<String, String>();
		for (ServiceProperty prop : serviceOffer.properties) {
			propsMap.put(prop.name, prop.value);
		}

		String host = "";
		try {
			ManagedConnection.setContextCurrentConnection(cnn);
			ParsedIOR ior = new ParsedIOR((ORB)cnn.orb(), serviceOffer.service_ref.toString());
			IIOPProfile profile = (IIOPProfile) ior.getProfiles().get(0);
			String ip = ((IIOPAddress) profile.getAddress()).getIP();
			String hostname = ((IIOPAddress) profile.getAddress()).getHostname();
			if (hostname != null && !hostname.isEmpty() && !ip.equals(hostname))
				ip += "(" + hostname + ")";
			host = " do host " + ip;
		}
		catch (Throwable e) {
			e.printStackTrace(System.err);
		}

		StringBuilder res = new StringBuilder();
		if (offerBean != null && offerBean.isInvalid())
			res.append("Oferta [Invlida]");
		else
			res.append("Oferta" + host);

		if (propsMap.containsKey("openbus.offer.entity")) {
			res.append(" (" + propsMap.get("openbus.offer.entity") + ")");
		}

		if (propsMap.containsKey("openbus.offer.id")) {
			res.append(" - ID:" + propsMap.get("openbus.offer.id"));
		}

		return res.toString();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((label == null) ? 0 : label.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof ServiceOfferNode)) {
			return false;
		}
		ServiceOfferNode other = (ServiceOfferNode) obj;
		if (label == null) {
			if (other.label != null) {
				return false;
			}
		}
		else if (!label.equals(other.label)) {
			return false;
		}
		return true;
	}

	@Override
	public String toString() {
		return label;
	}

	@Override
	public JPanel getDetailsPanel() {
		ServiceOfferNodeDetailsPanel details;
		if (detailsPanel != null)
			details = detailsPanel.get();
		else
			details = null;

		if (details == null) {
			details = new ServiceOfferNodeDetailsPanel(queryPropertiesInterface, serviceOffer);
			detailsPanel = new WeakReference<ServiceOfferNodeDetailsPanel>(details);
		}
		return details;
	}

	private static final ImageIcon deadIcon = new ImageIcon(OfferRegistryPanel.class.getResource("scull.png"));
	private static final ImageIcon icon = new ImageIcon(OfferRegistryPanel.class.getResource("server.png"));

	public Icon getIcon() {
		boolean invalid = offerBean != null && offerBean.isInvalid();
		return invalid ? deadIcon : icon;
	}

	@Override
	public Icon getClosedIcon() {
		return getIcon();
	}

	@Override
	public Icon getLeafIcon() {
		return getIcon();
	}

	@Override
	public Icon getOpenedIcon() {
		return getIcon();
	}

	@Override
	public JPopupMenu getPopupMenu() {
		JPopupMenu componentMenu = new JPopupMenu("Componente Ofertado");

		JMenuItem startupMenuItem = new JMenuItem("IComponent.startup()");
		startupMenuItem.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				SlowRequester.run(new SlowRunnable() {
					@Override
					public void run() throws Exception {
						ManagedConnection.setContextCurrentConnection(cnn);
						serviceOffer.service_ref.startup();
						JOptionPane.showMessageDialog(getMyTree(),
						  "IComponent.startup() executado sem exceo.");
					}

					@Override
					public void finish() {
						if (getException() != null) {
							Thread.getDefaultUncaughtExceptionHandler()
							  .uncaughtException(Thread.currentThread(), getException());
						}
						else {
							JOptionPane.showMessageDialog(getMyTree(),
							  "IComponent.startup() executado sem exceo.");
						}
					}
				}, true);
			}
		});
		componentMenu.add(startupMenuItem);

		JMenuItem shutdownMenuItem = new JMenuItem("IComponent.shutdown()");
		shutdownMenuItem.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				SlowRequester.run(new SlowRunnable() {
					@Override
					public void run() throws Exception {
						ManagedConnection.setContextCurrentConnection(cnn);
						serviceOffer.service_ref.shutdown();
					}

					@Override
					public void finish() {
						if (getException() != null) {
							Thread.getDefaultUncaughtExceptionHandler()
							  .uncaughtException(Thread.currentThread(), getException());
						}
						else {
							JOptionPane.showMessageDialog(getMyTree(),
							  "IComponent.shutdown() executado sem exceo.");
						}
					}
				}, true);
			}
		});
		componentMenu.add(shutdownMenuItem);

		JMenuItem removeOfferMenuItem = new JMenuItem("ServiceOffer.remove()");
		removeOfferMenuItem.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {

				if (JOptionPane.showConfirmDialog(getMyTree(),
				  "Confirma remoo de oferta?",
				  "Remoo de oferta",
				  JOptionPane.YES_NO_OPTION,
				  JOptionPane.WARNING_MESSAGE) == JOptionPane.NO_OPTION)
					return;

				SlowRequester.run(new SlowRunnable() {
					@Override
					public void run() throws Exception {
						ManagedConnection.setContextCurrentConnection(cnn);
						serviceOffer.ref.remove();
					}
				}, true);

			}
		});
		componentMenu.add(removeOfferMenuItem);

		return componentMenu;
	}

	@Override
	public void configureHelpTip(TipPanelInterface tipPanel) {
		tipPanel.setTips(new String[] {
		    "Clique com o boto direito do mouse sobre a tabela de propriedades da oferta " +
		      "para pr-configurar outra busca parametrizada ao servio de registros.",

		    "Clique com o boto direito do mouse sobre o n para poder invocar os mtodos " +
		      "do ciclo de vida do componente IComponent.startup() e IComponent.shutdown().",

		    "Clique com o boto direito do mouse sobre o n para poder remover a oferta " +
		      "atravs do ServiceOffer.remove()",

		    "Para conectar a faceta a um receptculo que a suporte, voc pode arrastar " +
		      "o n da rvore at um n do receptculo desejado.",

		    "Para conectar a faceta a um receptculo, voc pode \"copiar e colar\" o n da faceta " +
		      "no n do receptculo."

		}, new String[] {
		    "No d shutdown em componentes de terceiros.",
		    "No remova as ofertas dos coleguinhas sem avis-los antes!"
		});
	}

	public void setOfferPoolBean(ServiceOfferManagedBean offerBean) {
		if (this.offerBean != null)
			this.offerBean.removeObserver(offerObserver);
		this.offerBean = offerBean;
		if (this.offerBean != null)
			this.offerBean.addObserver(offerObserver);
	}

	@Override
	public Object getUserObject() {
		return this;
	}
	
	@Override
	public boolean hasString(String lowerCaseStringToSearch) {
		for (ServiceProperty prop : serviceOffer.properties){
			if (prop.value.toLowerCase().contains(lowerCaseStringToSearch)){
				return true;
			}
		}
	  return false;
	}
	
}
