package tecgraf.openbus.browser.scs_offers.data_service;

import java.awt.Dimension;
import java.awt.Font;

import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;

import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.data_service.core.v1_01.DataDescription;

/**
 * Painel de detalhes sobre um n que representa um DataKey Openbus.
 * No painel, todos os detalhes sobre o DataKey sero exibidos, dados estes
 * do {@link DataDescription} referente.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
@SuppressWarnings("serial")
final class DataKeyNodeDetailsPanel extends JPanel {

	private final DataKeyNodeBean bean;
	private final JTextField txtName;
	private final JTable tblMetadata;
	private JTextField txtDataKey;
	private static final Font fontForLabel = new Font(Font.MONOSPACED, Font.BOLD, 10);
	private static final Font fontForText = new Font(Font.MONOSPACED, Font.PLAIN, 10);
	private static final ImageIcon ICON_BASE64 =
	  new ImageIcon(DataKeyNodeDetailsPanel.class.getResource("binary-16.png"));
	private final JToggleButton btnBase64;
	private static boolean representingInBase64 = true;
	private JPanel pnlViews;

	protected DataKeyNodeDetailsPanel(DataKeyNodeBean dataKeyNodeBean) {
		this.bean = dataKeyNodeBean;
		setLayout(new MigLayout("", "[grow]", "[][][grow][grow]"));

		JLabel lblDatakey = new JLabel("DataKey:");
		lblDatakey.setFont(fontForLabel);
		add(lblDatakey, "flowx,cell 0 0");

		txtDataKey = new JTextField();
		txtDataKey.setEditable(false);
		txtDataKey.setBorder(null);
		txtDataKey.setFont(fontForText);
		lblDatakey.setLabelFor(txtDataKey);
		txtDataKey.setText(getDataKeyText());
		add(txtDataKey, "cell 0 0, grow");

		btnBase64 = new JToggleButton(ICON_BASE64);
		btnBase64.setMinimumSize(new Dimension(20, 20));
		btnBase64.setMaximumSize(new Dimension(20, 20));
		btnBase64.setToolTipText("Representar o datakey em base64");
		btnBase64.getModel().addChangeListener(new ChangeListener() {
			@Override
			public void stateChanged(ChangeEvent e) {
				if (btnBase64.isSelected()) {
					txtDataKey.setText(Base64.encodeToString(bean.getDataDescription().fKey, false));
				}
				else {
					txtDataKey.setText(new String(bean.getDataDescription().fKey));
				}
				representingInBase64 = btnBase64.isSelected();
			}
		});
		add(btnBase64, "cell 0 0");

		JLabel lblName = new JLabel("Nome:");
		lblName.setFont(fontForLabel);
		add(lblName, "flowx,cell 0 1");

		txtName = new JTextField();
		txtName.setEditable(false);
		txtName.setBorder(null);
		txtName.setFont(fontForText);
		lblName.setLabelFor(txtName);
		txtName.setText(bean.getDataDescription().fName);
		add(txtName, "cell 0 1,grow");

		JSplitPane splitDetails = new JSplitPane();
		splitDetails.setOrientation(JSplitPane.VERTICAL_SPLIT);
		add(splitDetails, "cell 0 2,grow");

		JScrollPane scrMetadata = new JScrollPane();
		splitDetails.setTopComponent(scrMetadata);
		splitDetails.setDividerLocation(100);
		splitDetails.setContinuousLayout(true);

		tblMetadata = new JTable();
		scrMetadata.setViewportView(tblMetadata);

		tblMetadata.setModel(new DefaultTableModel(getMetadataForTableModel(), new String[] {
		    "Metadado", "Valor"
		}) {
			@Override
			public boolean isCellEditable(int row, int column) {
				return false;
			}
		});

		pnlViews = new JPanel();
		pnlViews.setLayout(new BoxLayout(pnlViews, BoxLayout.Y_AXIS));
		splitDetails.setBottomComponent(new JScrollPane(pnlViews));

		addDataView(bean.getDataDescription().fDefaultView.fInterfaceName, true);
		for (String otherView : bean.getDataDescription().fOthersViews)
			addDataView(otherView, false);

		addAncestorListener(new AncestorListener() {
			@Override
			public void ancestorRemoved(AncestorEvent event) {
			}

			@Override
			public void ancestorMoved(AncestorEvent event) {
			}

			@Override
			public void ancestorAdded(AncestorEvent event) {
				btnBase64.setSelected(representingInBase64);
			}
		});
		//		
		//		tipPanel = new TipPanel(new String[]{
		//			"Se houver um IHierarchicalManagementDataService na mesma oferta deste " +
		//				"IHierarchicalNavigationDataService, voc pode acionar copyData() ou moveData() " +
		//				"arrastando os ns da rvore correspondentes entre si.",
		//			
		//			"Se houver um IHierarchicalManagementDataService na mesma oferta deste " +
		//				"IHierarchicalNavigationDataService, voc pode acionar copyData() ou moveData() " +
		//				"copiando e colando os ns do dataservice entre si."
		//		});
		//		

	}

	private void addDataView(String fInterfaceName, boolean isDefaultView) {

		if (fInterfaceName == null || fInterfaceName.isEmpty())
			return;

		JLabel newDataViewLabel = new JLabel(fInterfaceName);
		newDataViewLabel.setFont(new Font(Font.MONOSPACED, isDefaultView ? Font.BOLD : Font.PLAIN, 10));
		pnlViews.add(newDataViewLabel);

	}

	private String getDataKeyText() {
		String dataKeyString = new String(bean.getDataDescription().fKey);
		if (isPrintable(dataKeyString)) {
			return dataKeyString;
		}
		else {
			return Base64.encodeToString(bean.getDataDescription().fKey, false);
		}
	}

	private static final boolean isPrintable(String str) {
		for (int i = 0; i < str.length(); i += 1)
			if (!fontForText.canDisplay(str.charAt(i)))
				return false;
		return true;
	}

	private Object[][] getMetadataForTableModel() {
		Object[][] res = new Object[bean.getDataDescription().fMetadata.length][];
		for (int i = 0; i < res.length; i += 1) {
			res[i] = new Object[] {
			    bean.getDataDescription().fMetadata[i].fName,
			    bean.getDataDescription().fMetadata[i].fValue
			};
		}
		return res;
	}

}
