package tecgraf.openbus.browser.scs_offers.data_service;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

import org.jacorb.orb.ORB;

import tecgraf.openbus.Connection;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.scs_offers.AsyncExpandableTreeNode;
import tecgraf.openbus.browser.scs_offers.NodeWithIconsInterface;
import tecgraf.openbus.browser.scs_offers.SCSTree;
import tecgraf.openbus.browser.scs_offers.basic_nodes.FacetNodeBean;
import tecgraf.openbus.data_service.core.v1_01.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_01.DataDescription;
import tecgraf.openbus.data_service.core.v1_01.ServiceFailure;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalNavigationDataService;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalNavigationDataServiceHelper;

/**
 * Tipo de n que substitui o {@link FacetNodeBean} quando a faceta  especificamente
 * um {@link IHierarchicalNavigationDataService}.
 * <p>
 * Este tipo de n traz a facilidade de se poder expandir a rvore navegvel pelo
 * IHierarchicalNavigationDataService, utilizando a API padro.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
@SuppressWarnings("serial")
public final class HDataServiceNodeBean extends AsyncExpandableTreeNode implements NodeWithIconsInterface {

	private final FacetNodeBean myFacetBean;
	private final Connection cnn;

	private static final AtomicBoolean valueFactoriesRegistered_DataService = new AtomicBoolean(false);
	
	public HDataServiceNodeBean(SCSTree tree, Connection cnn, FacetNodeBean myFacetBean) {
		super(tree);
		this.myFacetBean = myFacetBean;
		this.cnn = cnn;
		if (!valueFactoriesRegistered_DataService.getAndSet(true)){
			ORB orb = (ORB)cnn.orb();
			orb.register_value_factory(
				tecgraf.openbus.data_service.project.v1_01.ProjectDataViewHelper.id(), 
				new tecgraf.openbus.data_service.project.v1_01.ProjectDataViewFactory());
			orb.register_value_factory(
				tecgraf.openbus.data_service.project.v1_01.ProjectItemDataViewHelper.id(), 
				new tecgraf.openbus.data_service.project.v1_01.ProjectItemDataViewFactory());
		}
	}

	@Override
	protected String getLoadingDescription() {
		return "Aguardando retorno de IHierarchicalNavigationDataService.getRoots()...";
	}

	@Override
	protected List<DefaultMutableTreeNode> loadChildren() throws ServiceFailure, DataAccessDenied {
		ManagedConnection.setContextCurrentConnection(cnn);
		IHierarchicalNavigationDataService hdsn =
		  IHierarchicalNavigationDataServiceHelper.narrow(myFacetBean.getFacetDescription().facet_ref);
		DataDescription roots[] = hdsn.getRoots();
		LinkedList<DefaultMutableTreeNode> res = new LinkedList<DefaultMutableTreeNode>();
		if (roots != null) {
			for (DataDescription ds : roots) {
				res.add(new DataKeyNodeBean(getMyTree(), cnn, myFacetBean, ds));
			}
		}
		return res;
	}

	private static final ImageIcon icon = new ImageIcon(HDataServiceNodeBean.class.getResource("hdataservice.png"));

	@Override
	public Icon getClosedIcon() {
		return icon;
	}

	@Override
	public Icon getLeafIcon() {
		return icon;
	}

	@Override
	public Icon getOpenedIcon() {
		return icon;
	}

}
