/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.api.authentication.v1;

import csbase.rest.api.authentication.v1.AuthenticationApiService;
import csbase.rest.api.authentication.v1.NotFoundException;
import csbase.rest.api.authentication.v1.factories.AuthenticationApiServiceFactory;
import csbase.rest.model.authentication.v1.InlineResponse200;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/authentication")
@Produces(value={"application/json;"})
@Api(description="the authentication API")
public class AuthenticationApi {
    private final AuthenticationApiService delegate = AuthenticationApiServiceFactory.getAuthenticationApi();

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Generate an access token for login and password", notes="", response=InlineResponse200.class, tags={"Authentication"})
    @ApiResponses(value={@ApiResponse(code=200, message="A JSON-encoded dictionary including an access token (accessToken), token type (tokenType), and user ID. The token type will always be \"bearer\".", response=InlineResponse200.class), @ApiResponse(code=401, message="Invalid login/password", response=InlineResponse200.class)})
    public Response authenticationPost(@ApiParam(value="the user's login", required=true) @FormParam(value="login") String login, @ApiParam(value="the user's password", required=true) @FormParam(value="password") String password, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.authenticationPost(login, password, locale, securityContext);
    }
}

