package csbase.client.algorithms.commands.newview;

import java.awt.Window;

/**
 * Base para implementao de uma aba no visualizador de comandos.
 */
abstract class AbstractTab implements Tab {

  /**
   * Indica o tipo da aba no visualizador de comandos.
   */
  public enum TabType {
    /**
     * Aba esttica (ex: aba de parmetros).
     */
    STATIC,

    /**
     * Aba recarregvel (ex: aba de log).
     */
    RELOADABLE
  }

  /**
   * Indica se a aba  a que est selecionada no momento.
   */
  protected boolean isSelected;
  /**
   * Tipo da aba.
   */
  protected TabType type;
  /**
   * Ttulo da aba
   */
  private final String title;

  /**
   * Janela dona da aba.
   */
  private Window owner;

  /**
   * Construtor.
   * 
   * @param type tipo da aba a ser criada.
   * @param title o ttulo da aba.
   * @param owner janela dona da aba.
   */
  public AbstractTab(TabType type, String title, Window owner) {
    this.type = type;
    this.title = title;
    this.owner = owner;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setSelected(boolean selected) {
    this.isSelected = selected;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isSelected() {
    return this.isSelected;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TabType getType() {
    return type;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getTitle() {
    return title;
  }

  /**
   * Retorna a janela dona da aba.
   * 
   * @return a janela.
   */
  public Window getOwner() {
    return owner;
  }

}