package csbase.client.algorithms.commands.newview;

import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import csbase.client.algorithms.commands.newview.AbstractTab.TabType;

/**
 * Classe utilitria *temporria* para determinar qual verso do visualizador de
 * comandos deve ser utilizada e ajudar a fazer a transio para a nva verso.
 */
public class NewCommandViewUtils {

  /**
   * Converte os valores da enumerao que determina o tipo da aba utilizada
   * anteriormente para a nova enumerao.
   * 
   * @param oldTabType tipo na enumerao antiga.
   * @return tipo na enumerao nova.
   */
  public static TabType getNewTabType(
    csbase.client.algorithms.commands.view.TabType oldTabType) {
    switch (oldTabType) {
      case LOG:
        return TabType.RELOADABLE;
      case PARAMETERS:
        return TabType.STATIC;
      default:
        return TabType.RELOADABLE;
    }
  }

  /**
   * Determina se a nova verso do visualizador de comando deve ser utilizada,
   * via {@link ConfigurationManager}.
   * 
   * @return verdadeiro se a nova verso deve ser utilizada ou falso, caso
   *         contrrio.
   */
  public static boolean useNewVersion() {
    ConfigurationManager cnfManager = ConfigurationManager.getInstance();
    final boolean defaultValue = false;

    boolean isEnabled;
    if (cnfManager == null) {
      isEnabled = defaultValue;
    }
    else {
      Class<LogTabConfiguration> propClass = LogTabConfiguration.class;
      try {
        Configuration cnf = cnfManager.getConfiguration(propClass);
        String propName = "enabled";
        Boolean propValue =
          cnf.getOptionalBooleanProperty(propName, defaultValue);
        if (propValue == null) {
          isEnabled = defaultValue;
        }
        else {
          isEnabled = propValue;
        }
      }
      catch (ConfigurationManagerException e) {
        isEnabled = defaultValue;
      }
    }
    return isEnabled;
  }

}
