package csbase.client.algorithms.commands.newview;

import java.awt.Component;
import java.awt.Window;

import tecgraf.javautils.gui.StatusBar;
import csbase.client.util.event.EventListener;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.LogPanel.FileEvent;
import csbase.client.util.gui.log.LogPanel.ThrowableEvent;
import csbase.client.util.gui.log.LogPanelReloader;
import csbase.logic.ClientProjectFile;

/**
 * Aba para visualizao de logs simples (um s arquivo sendo visualizado por
 * vez).
 */
class SimpleLogTab extends AbstractLogTab {

  /**
   * Painel de visualizao de logs.
   */
  private LogPanel logPanel;

  /**
   * Construtor.
   * 
   * @param title o ttulo da aba.
   * @param file o arquivo de log.
   * @param statusBar barra de status para apresentar mensagens da aba.
   * @param owner janela dona da aba.
   * @param autoReload indica se a aba deve ser recarregvel.
   */
  public SimpleLogTab(String title, ClientProjectFile file,
    StatusBar statusBar, Window owner, boolean autoReload) {
    super(title, statusBar, owner, autoReload);
    if (file != null) {
      logPanel.openFile(file);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void reload() {
    logPanel.reload();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getMainComponent() {
    return logPanel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected LogPanelReloader createReloader() {
    return logPanel.getReloader();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void initialize() {
    logPanel =
      LogPanel.createLogPanelWithToolBar(LogPanel.RELOAD | LogPanel.PAGING,
        LogPanel.DEFAULT_PAGE_SIZE_KB);
    logPanel.addThrowableEventListener(new EventListener<ThrowableEvent>() {
      @Override
      public void eventFired(ThrowableEvent event) {
        statusBar.setError(event.getMessage());
      }
    });

    logPanel.addFileEventListener(new EventListener<FileEvent>() {
      @Override
      public void eventFired(FileEvent event) {
        if (FileEvent.Type.NOT_FOUND == event.getType()) {
          logPanel.getReloader().stop();
          logPanel.closeFile();
        }
      }
    });
  }

}
