package csbase.client.algorithms.commands.view;

import tecgraf.javautils.configurationmanager.ConfigurationManager;

/**
 * Tipo de viso de log que um comando pode apresentar, dependendo da natureza
 * do seu configurador.
 */
public enum CommandViewType {
  /**
   * Viso de um algoritmo simples.
   */
  SIMPLE,
  /**
   * Viso de um fluxo.
   */
  FLOW,
  /**
   * Viso de um n de um fluxo.
   */
  NODE;

  /**
   * Nome da propriedade do {@link ConfigurationManager} que configura o padro
   * de nome do arquivo de log para cada tipo de viso.
   * 
   * @return O nome da propriedade.
   */
  public String getPropertyName() {
    switch (this) {
      case SIMPLE:
        return "simple";
      case FLOW:
        return "flow";
      case NODE:
        return "node";
      default:
        return "";
    }
  }
}