package csbase.client.algorithms.validation;

import tecgraf.javautils.core.lng.LNG;
import csbase.logic.algorithms.validation.FlowNodeValidationResult;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;

/**
 * Classe que auxilia a traduo de mensagens internacionalizveis.
 */
public class ValidationTranslator {

  /**
   * Traduz a mensagem da validao.
   * 
   * @param validation a validao.
   * @return a mensagem traduzida.
   */
  public static String translateMessage(Validation validation) {
    StringBuilder message = new StringBuilder();
    if (validation != null) {
      message.append(getMessage(validation.getMessage()));
      if (validation instanceof FlowNodeValidationResult) {
        FlowNodeValidationResult flowNodeValidation =
          (FlowNodeValidationResult) validation;
        String elementDescription =
          "(" + flowNodeValidation.getElement() + ") ";
        message.insert(0, elementDescription);
      }
    }
    return message.toString();
  }

  /**
   * Indica se existe uma mensagem internacionalizada definida para a chave
   * definida.
   * 
   * @param message mensagem internacionalizvel.
   * @return verdadeiro se existe uma mensagem ou falso, caso contrrio.
   */
  public static boolean hasLocalizedMessage(LocalizedMessage message) {
    if (message != null) {
      return LNG.hasKey(message.getKey());
    }
    else {
      return false;
    }
  }

  /**
   * Obtm a mensagem j localizada.
   * 
   * @param message mensagem internacionalizvel.
   * @return a mensagem.
   */
  public static String getMessage(LocalizedMessage message) {
    if (hasLocalizedMessage(message)) {
      return getLocalizedMessage(message);
    }
    else {
      return message.toString();
    }
  }

  /**
   * Obtm a mensagem j localizada.
   * 
   * @param message mensagem internacionalizvel.
   * @return a mensagem.
   */
  public static String getLocalizedMessage(LocalizedMessage message) {
    if (message != null) {
      Object[] args = message.getArgs();
      String key = message.getKey();
      if (args != null && args.length > 0) {
        return LNG.get(key, args);
      }
      else {
        return LNG.get(key);
      }
    }
    else {
      return "";
    }
  }
}
