package csbase.client.applications.jobmonitor.rowmodel;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import csbase.client.applications.jobmonitor.drivers.JobInfoDriver;

/**
 * Define o modelo de uma linha da tabela que exibe informaes dos jobs. Essa
 * classe, basicamente, encapsula um mapa do tipo (String -> String). Os objetos
 * dessa classe fazem o mapeamento do nome da coluna e o valor que essa coluna
 * exibe.
 * 
 * @see JobInfoDriver
 * 
 * @author Tecgraf
 */
public class JobInfoRow {

  /** Mapa (Nome da coluna -> Valor) */
  private Map<String, String> row;

  /**
   * Construtor padro.
   */
  public JobInfoRow() {
    row = new LinkedHashMap<String, String>();
  }

  /**
   * Adiciona novo elemento na linha.
   * 
   * @param key - chave do elemento.
   * @param value - valor do elemento.
   */
  public void add(String key, String value) {
    row.put(key, value);
  }

  /**
   * Obtm o valor associado a chave.
   * 
   * @param key - chave do elemento.
   * @return valor associado a chave.
   */
  public String get(String key) {
    return row.get(key);
  }

  /**
   * Conjunto com todas as chaves.
   * 
   * @return chaves.
   */
  public Set<String> keySet() {
    return row.keySet();
  }

  /**
   * Conjunto dos pares que compem uma linha.
   * 
   * @return conjunto dos pares que compem uma linha.
   */
  public Set<Entry<String, String>> entrySet() {
    return row.entrySet();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return row.toString();
  }
}
