package csbase.client.applications.statsviewer.graphic;

import java.util.Observable;

import csbase.client.applications.statsviewer.LogsView;
import csbase.client.applications.statsviewer.StatsViewer;

/**
 * Painel que exibe o grfico com as execues realizadas pelos usurios (exibe
 * apenas as 10 maiores ocorrncias, desconsiderando o usurio admin).
 */
public class ExecutionsUsersPanel extends GraphicPanel {

  /**
   * Construtor do painel.
   *
   * @param app referncia para a aplicao que iniciou o painel
   * @param title ttulo do grfico
   */
  public ExecutionsUsersPanel(final StatsViewer app, String title) {
    super(app, title);
    newBarChart3DPanel(app.getString("users"), app
      .getString("executions.number"), false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void update(Observable appObservable, Object view) {
    LogsView infoView = (LogsView) view;
    updateSubTitle(infoView.getInfo());
    updateSimpleDataSet(infoView.getTop10UserExecutions(), app
      .getString("user"));
  }

}
