package csbase.client.applications.statsviewer.graphic;

import java.util.Observable;

import csbase.client.applications.statsviewer.LogsView;
import csbase.client.applications.statsviewer.StatsViewer;

/**
 * Painel que exibe o grfico com os logins realizados no tempo (desconsiderando
 * os logins realizados pelo usurio admin).
 */
public class LoginsDatePanel extends GraphicPanel {

  /**
   * Construtor do painel.
   *
   * @param app referncia para a aplicao que iniciou o painel
   * @param title ttulo do grfico
   */
  public LoginsDatePanel(StatsViewer app, String title) {
    super(app, title);
    newBarChart3DPanel(app.getString("date"), app.getString("logins.number"),
      false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void update(Observable appObservable, Object view) {
    LogsView infoView = (LogsView) view;
    updateSubTitle(infoView.getInfo());
    updateSimpleDataSet(infoView.getLoginsByDate(), app.getString("date"));
  }

}
