/*
 * $Id: DirectoryContentsTransferHandler.java 75203 2008-04-18 12:06:37Z taciana
 * $
 */
package csbase.client.desktop.dircontents;

import java.awt.Window;
import java.awt.datatransfer.DataFlavor;

import javax.swing.JComponent;
import javax.swing.JTable;

import csbase.client.project.AbstractProjectFileTransferHandler;
import csbase.logic.ClientProjectFile;

/**
 * Handler
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DirectoryContentsTransferHandler extends
  AbstractProjectFileTransferHandler {

  /**
   * Verifica se o componente pode fazer importao.
   * 
   * @param c O componente sobre o qual a transferncia foi iniciada.
   * @param flavor Os formatos de dados dos objetos que esto sendo
   *        transferidos.
   * 
   * @return Verdadeiro, se o componente permite iniciar a transferncia dos
   *         objetos com o formato especificado.
   */
  @Override
  public boolean canImport(final JComponent c, final DataFlavor[] flavor) {
    if (!(c instanceof JTable)) {
      return false;
    }
    final JTable table = (JTable) c;
    if (table.getEditingRow() != -1) {
      return false;
    }
    return super.canImport(c, flavor);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ClientProjectFile getDestinationDirectory(
    final JComponent destination) {
    if (destination instanceof JTable) {
      final JTable table = (JTable) destination;
      final int selectedRow = table.getSelectedRow();
      final int column = DirectoryContentsPanel.NAME_COL_INDEX;
      final ClientProjectFile dir = (ClientProjectFile) table.getValueAt(
        selectedRow, column);
      return dir;
    }
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ClientProjectFile[] getFilesToExport(final JComponent source) {
    if (source instanceof JTable) {
      final JTable table = (JTable) source;
      final int[] selectedRows = table.getSelectedRows();

      if (selectedRows.length > 0) {
        final ClientProjectFile[] files = new ClientProjectFile[selectedRows.length];
        for (int inx = 0; inx < files.length; inx++) {
          files[inx] = (ClientProjectFile) table.getValueAt(selectedRows[inx],
            DirectoryContentsPanel.NAME_COL_INDEX);
//          System.out.println(files[inx].getName() + " - "
//            + files[inx].getParent());
        }
        return files;
      }
    }

    return null;
  }

  /**
   * Constri um handler de transferncia de objetos de uma tabela de projeto.
   * 
   * @param ownerWindow A janela sobre a qual uma DesktopTask deve ser efetuada.
   * @param ownerTitle O ttulo da janela de DesktopTask
   */
  public DirectoryContentsTransferHandler(final Window ownerWindow,
    final String ownerTitle) {
    super(ownerWindow, ownerTitle);
  }
}
