package csbase.client.facilities.commandtable;

import java.net.URL;

import javax.swing.ImageIcon;

import csbase.client.util.AnimatedIcon;

/**
 * Clase esttica que possui todos os cones que representam os possveis
 * estados de um comando.  responsvel pela montagem de uma imagem do resource
 * de uma aplicao com base na biblioteca localizada em
 * <code>"/csbase/client/resources/commandimages/"</code>.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CommandImages {

  /**
   * Diretrio das imagens de comando
   */
  public static final String COMMAND_ICON_DIR =
    "/csbase/client/resources/commandimages/";

  /**
   * Imagem para representar comandos sem estado.
   */
  public static final ImageIcon ICON_CMD_NONE = createCommandImage("none");

  /**
   * Imagem para representar o estado
   * {@link csbase.logic.CommandFinalizationType#END}
   */
  public static final ImageIcon ICON_CMD_END = createCommandImage("end");

  /**
   * Imagem para representar o estado
   * {@link csbase.logic.CommandFinalizationType#EXECUTION_ERROR}
   */
  public static final ImageIcon ICON_CMD_ERROR = createCommandImage("error");

  /**
   * Imagem para representar o estado
   * {@link csbase.logic.CommandFinalizationType#SUCCESS}
   */
  public static final ImageIcon ICON_CMD_SUCCESS =
    createCommandImage("success");

  /**
   * Imagem para representar o estado
   * {@link csbase.logic.CommandFinalizationType#FAILED}
   */
  public static final ImageIcon ICON_CMD_FAIL = createCommandImage("fail");

  /**
   * Imagem para representar o estado
   * {@link csbase.logic.CommandFinalizationType#KILLED}
   */
  public static final ImageIcon ICON_CMD_KILLED = createCommandImage("killed");

  /**
   * Imagem para representar o estado
   * {@link csbase.logic.CommandFinalizationType#LOST}
   */
  public static final ImageIcon ICON_CMD_LOST = createCommandImage("lost");

  /**
   * Imagem para representar o estado
   * {@link csbase.logic.CommandFinalizationType#NO_EXIT_CODE}
   */
  public static final ImageIcon ICON_CMD_NO_CODE =
    createCommandImage("no-code");

  /**
   * Imagem para representar o estado
   * {@link csbase.logic.CommandFinalizationType#UNKNOWN}
   */
  public static final ImageIcon ICON_CMD_UNKNOWN =
    createCommandImage("unknown");

  /**
   * Imagem para representar o estado {@link csbase.logic.CommandStatus#INIT}
   */
  public static final ImageIcon ICON_CMD_INIT = createCommandImage("init");

  /**
   * Imagem para representar o estado
   * {@link csbase.logic.CommandStatus#EXECUTING}
   */
  public static final AnimatedIcon ICON_CMD_EXECUTING_ANIMATED =
    createCommandAnimatedImage("running");

  /**
   * Imagem para representar o estado
   * {@link csbase.logic.CommandStatus#DOWNLOADING}
   */
  public static final ImageIcon ICON_CMD_DOWNLOADING =
    createCommandImage("downloading");

  /**
   * Imagem para representar o estado
   * {@link csbase.logic.CommandStatus#UPLOADING}
   */
  public static final ImageIcon ICON_CMD_UPLOADING =
    createCommandImage("uploading");

  /**
   * Imagem para representar o estado
   * {@link csbase.logic.CommandStatus#SCHEDULED}
   */
  public static final ImageIcon ICON_CMD_SCHEDULED =
    createCommandImage("scheduled");

  /**
   * Imagem para representar o estado
   * {@link csbase.logic.CommandStatus#SYSTEM_FAILURE}
   */
  public static final ImageIcon ICON_CMD_SYSTEM_FAILURE =
    createCommandImage("system-failure");

  /**
   * Imagem para representar comandos que esto na fila do escalonador de um
   * cluster.
   * 
   * @see csbase.logic.CommandInfo#isQueued
   */
  public static final ImageIcon ICON_CMD_QUEUED = createCommandImage("queued");

  /**
   * Imagem para representar comandos cujas informaes no esto disponveis
   * por problemas de comunicao.
   * 
   * @see csbase.logic.CommandInfo#isValid
   */
  public static final ImageIcon ICON_CMD_DISCONNECTED =
    createCommandImage("disconnected");

  /**
   * Extenso padro dos arquivos (formato) das imagens.
   */
  private static final String IMAGE_EXTENSION = "png";

  /**
   * Extenso padro dos arquivos (formato) das imagens animadas.
   */
  private static final String ANIMATED_IMAGE_EXTENSION = "gif";

  /**
   * Cria a imagem a partir do nome do arquivo.
   * 
   * @param name nome do arquivo de imagem.
   * 
   * @return a imagem
   */
  protected static ImageIcon createCommandImage(String name) {
    return createImageIcon(name, COMMAND_ICON_DIR, IMAGE_EXTENSION);
  }

  /**
   * Cria a imagem animada a partir do nome do arquivo.
   * 
   * @param name nome do arquivo de imagem.
   * 
   * @return a imagem animada
   */
  protected static AnimatedIcon createCommandAnimatedImage(String name) {
    ImageIcon imageIcon =
      createImageIcon(name, COMMAND_ICON_DIR, ANIMATED_IMAGE_EXTENSION);
    if (imageIcon != null) {
      return new AnimatedIcon(imageIcon);
    }
    return null;
  }

  /**
   * Cria a imagem a partir das informaes de nome, diretrio e extenso.
   * 
   * @param imageIconName nome do arquivo de imagem.
   * @param imageDir Caminho do diretrio das imagens
   * @param imageExtension Extenso do arquivo de imagem
   * @return a imagem
   */
  protected static ImageIcon createImageIcon(String imageIconName,
    String imageDir, String imageExtension) {
    String resPath = imageDir + imageIconName + "." + imageExtension;
    URL res = CommandImages.class.getResource(resPath);
    if (res == null) {
      System.err.println("No foi possvel criar a imagem de comando.\n"
        + "nome:" + imageIconName + " no caminho: " + resPath);
      return ICON_CMD_NONE;
    }
    return new ImageIcon(res);
  }

}
