/*
 * $Id: CommonFileDeleteAction.java 150777 2014-03-19 14:16:56Z oikawa $
 */
package csbase.client.project.action;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectFileContainer;
import csbase.logic.ClientProjectFile;

/**
 * Ao de remoo de arquivo/diretrio
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CommonFileDeleteAction extends CommonProjectAction {

  /**
   * Nome da ao.
   */
  private static final String ACTION_NAME = LNG.get("PRJ_DELETE");

  /**
   * Construtor
   * 
   * @param container o container
   */
  public CommonFileDeleteAction(ProjectFileContainer container) {
    super(container);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    // FIXME este mtodo est muito grande
    ClientProjectFile[] candidateFiles = getSelectedFiles();
    if (candidateFiles == null || candidateFiles.length == 0) {
      return;
    }
    final List<ClientProjectFile> files = filterParentDirs(candidateFiles);

    if (files.isEmpty()) {
      /*
       * todos os arquivos selecionados eram ".."
       */
      return;
    }
    final Window owner = getWindow();
    /*
     * se um dos arquivos selecionados era a raiz do projeto, exibimos uma
     * mensagem de erro e abortamos
     */
    for (ClientProjectFile file : files) {
      if (file.isRoot()) {
        StandardDialogs.showErrorDialog(owner, LNG.get("GENERIC.title.error"),
          LNG.get("PRJ_REMOVAL_ONLY_VIA_MENU"));
        return;
      }
    }

    String nodeType;
    String confirmation;
    final String windowTitle;
    String name;
    final ClientProjectFile file0 = files.get(0);

    if (files.size() > 1) {
      /*
       * mltiplos arqs/dirs sero removidos
       */
      name = LNG.get("PRJ_MULT_SELECTION");
      nodeType = LNG.get("PRJ_DIRS") + '/' + LNG.get("PRJ_FILES");
      windowTitle =
        MessageFormat.format(LNG.get("PRJ_PROJECT_MULT_FILE_REMOVAL_TITLE"),
          new Object[] { nodeType });
      confirmation =
        MessageFormat.format(
          LNG.get("PRJ_PROJECT_MULT_FILE_REMOVAL_CONFIRMATION"),
          new Object[] { nodeType });
    }
    else {
      /*
       * apenas um arq/dir ser removido
       */
      name = file0.getName();
      if (!file0.isDirectory()) {
        /*
         * vamos remover apenas um arq
         */
        nodeType = LNG.get("PRJ_FILE");
        windowTitle =
          MessageFormat.format(LNG.get("PRJ_PROJECT_FILE_REMOVAL_TITLE"),
            new Object[] { nodeType });
        if (file0.isUnderConstruction()) {
          confirmation =
            MessageFormat.format(LNG.get("PRJ_PROJECT_FILE_UNDERCONSTRUCTION"),
              nodeType, name);
        }
        else {
          confirmation = "";
        }
        confirmation =
          confirmation
            + MessageFormat.format(
              LNG.get("PRJ_PROJECT_FILE_REMOVAL_CONFIRMATION"), nodeType, name);
      }
      else {
        /*
         * vamos remover apenas um dir
         */
        nodeType = LNG.get("PRJ_DIRECTORY");
        windowTitle =
          MessageFormat.format(LNG.get("PRJ_PROJECT_FILE_REMOVAL_TITLE"),
            new Object[] { nodeType });
        final ClientProjectFile f = file0;
        if (!f.hasChildren()) {
          /*
           * dir no tem filhos
           */
          confirmation =
            MessageFormat.format(
              LNG.get("PRJ_PROJECT_FILE_REMOVAL_CONFIRMATION"), new Object[] {
                  nodeType, name });
        }
        else {
          /*
           * dir tem filhos
           */
          confirmation =
            MessageFormat.format(
              LNG.get("PRJ_PROJECT_FILE_REMOVAL_CONFIRMATION"), new Object[] {
                  nodeType, name })
              + '\n'
              + MessageFormat.format(
                LNG.get("PRJ_PROJECT_DIRECTORY_FILES_WILL_BE_REMOVED"),
                new Object[] { name });
        }
      }
    }

    /* Confirma se vai mesmo apagar o arquivo */
    Object[] options = { LNG.get("PRJ_REMOVAL"), LNG.get("PRJ_CANCEL") };
    int opt =
      StandardDialogs.showOptionDialog(owner, windowTitle, confirmation,
        options);
    if (opt != 0) {
      return;
    }

    /* Remove os dados do clipboard */
    clearClipboard();

    /* Solicita a execuo dessa tarefa no servidor */
    RemoteTask<Void> task = createFileRemovalTask(files, owner);

    /*
     * Executa a tarefa. Os erros so tratados diretamente por ela.
     */
    task.execute(
      owner,
      windowTitle,
      MessageFormat.format(LNG.get("PRJ_WAITING_DELETE_FILE"), new Object[] {
          nodeType, name }));
  }

  /**
   * Cria a tarefa remota para remoo dos arquivos.
   * 
   * @param files lista dos arquivos a serem removidos
   * @param owner janela-me da tarefa
   * @return tarefa remota para remoo dos arquivos
   */
  private RemoteTask<Void> createFileRemovalTask(
    final List<ClientProjectFile> files, final Window owner) {
    return new RemoteTask<Void>() {

      @Override
      protected void performTask() throws Exception {
        int size = files.size();
        if (size == 1) {
          files.get(0).remove();
        }
        else {
          getProject().removeFiles(files);
        }
      }
    };
  }

  /**
   * Remove da lista de arquivos selecionados os diretrios "..".
   * 
   * @param selectedFiles arquivos selecionados pelo usurio
   * 
   * @return lista com os arquivos selecionados, com exceo dos diretrios ".."
   */
  private List<ClientProjectFile> filterParentDirs(
    ClientProjectFile[] selectedFiles) {
    List<ClientProjectFile> files = new ArrayList<ClientProjectFile>();
    for (ClientProjectFile projectFile : selectedFiles) {
      files.add(projectFile);
    }
    return files;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return ACTION_NAME;
  }
}
