/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms;

import csbase.client.algorithms.AlgorithmChooserEvent;
import csbase.client.algorithms.AlgorithmChooserListener;
import csbase.client.algorithms.HelpAlgorithmVersionAction;
import csbase.client.algorithms.ShowHistoryAction;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.HistoryProvider;
import csbase.logic.algorithms.HistoryRecord;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public final class AlgorithmChooserPanel
extends JPanel {
    private final JComboBox algorithmComboBox;
    private SortedSet<AlgorithmInfo> algorithmInfoSet;
    private final JLabel algorithmLabel;
    private JTextArea descriptionTextArea;
    private HelpAlgorithmVersionAction helpVersionAction;
    private JButton helpVersionButton;
    private final List<AlgorithmChooserListener> listenerList = new LinkedList<AlgorithmChooserListener>();
    private ShowHistoryAction showHistoryAction;
    private JButton showHistoryButton;
    private final JComboBox versionComboBox;
    private final JLabel versionLabel;

    public AlgorithmChooserPanel(Window window, boolean showHistory) {
        this(window, showHistory, true);
    }

    public AlgorithmChooserPanel(Window window, boolean showHistory, boolean showDetails) {
        this.algorithmInfoSet = new TreeSet<AlgorithmInfo>();
        this.algorithmLabel = new JLabel(this.getString("algorithmLabel"));
        this.algorithmComboBox = this.makeAlgorithmComboBox();
        this.versionLabel = new JLabel(this.getString("versionLabel"));
        this.versionComboBox = this.makeAlgorithmVersionComboBox();
        if (showDetails) {
            this.descriptionTextArea = this.makeDescriptionTextArea();
            this.helpVersionAction = new HelpAlgorithmVersionAction(window);
            this.helpVersionAction.hideName();
            this.helpVersionButton = new JButton(this.helpVersionAction);
            GUIUtils.trimImageButton((AbstractButton)this.helpVersionButton);
        }
        if (showHistory) {
            this.showHistoryAction = new ShowHistoryAction(window);
            this.showHistoryButton = new JButton(this.showHistoryAction);
            this.showHistoryButton.setText("");
            this.showHistoryButton.setToolTipText(this.getString("showHistoryButton"));
            GUIUtils.trimImageButton((AbstractButton)this.showHistoryButton);
        }
        this.populatePanel();
    }

    public void addAlgorithmChooserListener(AlgorithmChooserListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listenerList.add(listener);
    }

    public AlgorithmInfo getSelectedAlgorithmInfo() {
        return (AlgorithmInfo)this.algorithmComboBox.getSelectedItem();
    }

    public AlgorithmVersionInfo getSelectedVersionInfo() {
        return (AlgorithmVersionInfo)this.versionComboBox.getSelectedItem();
    }

    public boolean hasAlgorithms() {
        return this.algorithmInfoSet.size() != 0;
    }

    public boolean hasVersions() {
        ComboBoxModel model = this.versionComboBox.getModel();
        return model.getSize() != 0;
    }

    public boolean selectAlgorithm(String algorithmName) {
        for (AlgorithmInfo algorithmInfo : this.algorithmInfoSet) {
            String algName = algorithmInfo.getName();
            if (!algName.equals(algorithmName)) continue;
            this.algorithmComboBox.setSelectedItem(algorithmInfo);
            return true;
        }
        return false;
    }

    public boolean selectVersion(AlgorithmVersionId versionId) {
        AlgorithmInfo algorithmInfo = this.getSelectedAlgorithmInfo();
        if (algorithmInfo == null) {
            return false;
        }
        AlgorithmVersionInfo versionInfo = algorithmInfo.getVersionInfo((Object)versionId);
        if (versionInfo == null) {
            return false;
        }
        this.versionComboBox.setSelectedItem(versionInfo);
        return true;
    }

    public void setAlgorithmSet(Set<AlgorithmInfo> algorithmInfoSet) {
        this.algorithmInfoSet = new TreeSet<AlgorithmInfo>(algorithmInfoSet);
        this.loadAlgorithms();
    }

    public void setAlgorithmVersion(Set<AlgorithmVersionInfo> algorithmVersionSet) {
        this.loadVersions(new TreeSet<AlgorithmVersionInfo>(algorithmVersionSet));
    }

    public void setDescription(String description) {
        if (this.descriptionTextArea != null) {
            this.descriptionTextArea.setText(description);
            this.descriptionTextArea.setCaretPosition(0);
            this.descriptionTextArea.setEnabled(this.isEnabled());
        }
    }

    private void fireChangedAlgorithm() {
        for (AlgorithmChooserListener listener : this.listenerList) {
            listener.wasChangedAlgorithm(new AlgorithmChooserEvent(this));
        }
    }

    private void fireChangedVersion() {
        for (AlgorithmChooserListener listener : this.listenerList) {
            listener.wasChangedVersion(new AlgorithmChooserEvent(this));
        }
    }

    private String getString(String key) {
        String className = AlgorithmChooserPanel.class.getName();
        return LNG.get((String)(className + "." + key));
    }

    private void loadAlgorithms() {
        this.algorithmComboBox.removeAllItems();
        for (AlgorithmInfo algorithm : this.algorithmInfoSet) {
            this.algorithmComboBox.addItem(algorithm);
        }
    }

    private void loadVersions() {
        AlgorithmInfo info = this.getSelectedAlgorithmInfo();
        TreeSet versions = new TreeSet(info.getVersions());
        this.versionComboBox.removeAllItems();
        for (AlgorithmVersionInfo version : versions) {
            this.versionComboBox.addItem(version);
        }
    }

    private void loadVersions(Set<AlgorithmVersionInfo> versions) {
        this.versionComboBox.removeAllItems();
        for (AlgorithmVersionInfo version : versions) {
            this.versionComboBox.addItem(version);
        }
    }

    private JComboBox makeAlgorithmComboBox() {
        JComboBox combo = new JComboBox();
        combo.addItemListener(new AlgorithmComboBoxItemListener());
        return combo;
    }

    private JComboBox makeAlgorithmVersionComboBox() {
        JComboBox combo = new JComboBox();
        combo.addItemListener(new VersionComboBoxItemListener());
        return combo;
    }

    private JTextArea makeDescriptionTextArea() {
        JTextArea descriptionTxtArea = new JTextArea(3, 35);
        descriptionTxtArea.setLineWrap(true);
        descriptionTxtArea.setWrapStyleWord(true);
        descriptionTxtArea.setBackground(this.getBackground());
        descriptionTxtArea.setEditable(false);
        descriptionTxtArea.setFont(new Font("Monospaced", 0, 12));
        return descriptionTxtArea;
    }

    private void populatePanel() {
        JPanel middle = new JPanel(new GridBagLayout());
        middle.add((Component)this.versionComboBox, new GBC(0, 0).horizontal());
        int px = 1;
        if (this.showHistoryButton != null) {
            middle.add((Component)this.showHistoryButton, new GBC(px, 0).none().insets(0, 5, 0, 0));
            ++px;
        }
        if (this.helpVersionButton != null) {
            middle.add((Component)this.helpVersionButton, new GBC(px, 0).none().insets(0, 5, 0, 0));
            ++px;
        }
        JComponent[][] rows = new JComponent[][]{{this.algorithmLabel, this.algorithmComboBox}, {this.versionLabel, middle}};
        JPanel header = GUIUtils.createBasicGridPanel((JComponent[][])rows);
        this.setLayout(new GridBagLayout());
        this.add((Component)header, new GBC(0, 0).horizontal());
        if (this.descriptionTextArea != null) {
            JScrollPane sPane = new JScrollPane(this.descriptionTextArea);
            sPane.setVerticalScrollBarPolicy(22);
            BorderUtil.setTitledBorder((JComponent)sPane, (String)this.getString("descriptionLabel"));
            this.add((Component)sPane, new GBC(0, 1).both());
        }
    }

    private void updateHelpAction() {
        if (this.helpVersionAction != null) {
            this.helpVersionAction.setAlgorithmVersionInfo(this.getSelectedVersionInfo());
        }
    }

    private void updateShowHistoryAction() {
        if (this.showHistoryAction != null) {
            AlgorithmVersionInfo vInfo = this.getSelectedVersionInfo();
            AlgorithmVersionHistoryProvider provider = new AlgorithmVersionHistoryProvider(vInfo);
            this.showHistoryAction.setHistoryProvider(provider);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.algorithmComboBox.setEnabled(enabled);
        this.algorithmLabel.setEnabled(enabled);
        this.versionComboBox.setEnabled(enabled);
        this.versionLabel.setEnabled(enabled);
        if (this.descriptionTextArea != null) {
            this.descriptionTextArea.setEnabled(enabled);
        }
        if (this.helpVersionButton != null) {
            this.helpVersionButton.setEnabled(enabled);
        }
        if (this.showHistoryButton != null) {
            this.showHistoryButton.setEnabled(enabled);
        }
    }

    private final class VersionComboBoxItemListener
    implements ItemListener {
        private VersionComboBoxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                AlgorithmChooserPanel.this.updateHelpAction();
                AlgorithmChooserPanel.this.updateShowHistoryAction();
                AlgorithmChooserPanel.this.fireChangedVersion();
            }
        }
    }

    private final class AlgorithmVersionHistoryProvider
    implements HistoryProvider {
        private final AlgorithmVersionInfo versionInfo;

        public AlgorithmVersionHistoryProvider(AlgorithmVersionInfo versionInfo) {
            this.versionInfo = versionInfo;
        }

        public List<HistoryRecord> getHistory() {
            String[] path = this.getVersionPath();
            return AlgorithmManagementProxy.retrieveHistory(path);
        }

        public String getName() {
            return FileUtils.joinPath((char)'/', (String[])this.getVersionPath());
        }

        private String[] getVersionPath() {
            return this.versionInfo.getDirPath().split("/");
        }
    }

    private final class AlgorithmComboBoxItemListener
    implements ItemListener {
        private AlgorithmComboBoxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                AlgorithmChooserPanel.this.fireChangedAlgorithm();
                AlgorithmChooserPanel.this.loadVersions();
            }
        }
    }
}

