/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms;

import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.RemoteTask;
import csbase.client.desktop.Task;
import csbase.client.externalresources.ExternalResources;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.CSBaseException;
import csbase.logic.FileInfo;
import csbase.logic.RemoteFileInputStream;
import csbase.logic.Utilities;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.pdfviewer.core.PDFDocument;
import tecgraf.javautils.pdfviewer.core.PDFReader;
import tecgraf.javautils.pdfviewer.dialog.PDFDialog;

public final class HelpAlgorithmVersionAction
extends AbstractAction {
    private AlgorithmVersionInfo versionInfo;
    private final Window window;

    public HelpAlgorithmVersionAction(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("O par\u00e2metro window est\u00e1 nulo.");
        }
        this.window = window;
        this.showName();
        this.showIcon();
        this.putValue("ShortDescription", LNG.get((String)"algorithms.full_description"));
        this.setEnabled(false);
    }

    public HelpAlgorithmVersionAction(Window window, AlgorithmVersionInfo versionInfo) {
        this(window);
        if (versionInfo == null) {
            throw new IllegalArgumentException("O par\u00e2metro versionInfo est\u00e1 nulo.");
        }
        this.setAlgorithmVersionInfo(versionInfo);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.versionInfo == null) {
            throw new IllegalStateException("N\u00e3o existe vers\u00e3o corrente, ou seja, o atributo versionInfo est\u00e1 nulo.\nUse setAlgorithmVersionInfo ou o construtor que recebe algorithmVersionInfo.");
        }
        List documentation = this.versionInfo.getDocumentation();
        String simplePath = documentation.size() == 1 ? ((FileInfo)documentation.get(0)).getPath() : "index.html";
        if (this.isResourcePDF(simplePath) && this.usesPDFViewer()) {
            try {
                final RemoteFileInputStream stream = this.getStreamForPDF(simplePath);
                if (stream == null) {
                    return;
                }
                RemoteTask<PDFDocument> openPdfDocTask = new RemoteTask<PDFDocument>(){

                    protected void performTask() throws Exception {
                        PDFDocument document = new PDFReader().read((InputStream)stream);
                        this.setResult(document);
                    }
                };
                String msgPrefix = HelpAlgorithmVersionAction.class.getSimpleName();
                String taskTitle = LNG.get((String)(msgPrefix + ".task.title"));
                String taskDescription = LNG.get((String)(msgPrefix + ".task.message"));
                openPdfDocTask.execute(this.window, taskTitle, taskDescription);
                if (openPdfDocTask.getStatus()) {
                    PDFDialog pdfDialog = new PDFDialog(this.window, simplePath, LNG.getLocale());
                    pdfDialog.loadDocument((PDFDocument)openPdfDocTask.getResult());
                    pdfDialog.setVisible(true);
                } else if (openPdfDocTask.getError() != null) {
                    this.showError(openPdfDocTask.getError());
                }
            }
            catch (Exception e) {
                this.showError(e);
            }
            return;
        }
        String htmlDirPath = this.versionInfo.getVersionsDirName() + "/" + this.versionInfo.getDirectory() + "/" + this.versionInfo.getDocumentationDirName();
        String filePath = htmlDirPath + "/" + simplePath;
        String[] filePathArray = Utilities.splitProjectPath((String)filePath);
        String urlStr = AlgorithmManagementProxy.retrieveDownloadURL(this.versionInfo.getInfo().getId(), filePathArray, this.window);
        if (urlStr == null) {
            String msg = LNG.get((String)"algorithms.error.no_help_for_version");
            Object[] args = new Object[]{this.versionInfo.getInfo(), this.versionInfo};
            msg = MessageFormat.format(msg, args);
            this.showError(msg);
            return;
        }
        try {
            URL url = new URL(urlStr);
            ExternalResources extResources = ExternalResources.getInstance();
            if (extResources.isEnabled()) {
                extResources.showDocument(url);
                return;
            }
        }
        catch (MalformedURLException e) {
            this.showError(e);
            return;
        }
        catch (CSBaseException e) {
            this.showError(e);
        }
    }

    private boolean isResourcePDF(String filePath) {
        return filePath.endsWith(".pdf") || filePath.endsWith(".PDF");
    }

    private RemoteFileInputStream getStreamForPDF(final String filePath) throws Exception {
        final AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        Task<RemoteFileInputStream> task = new Task<RemoteFileInputStream>(){

            protected void performTask() throws Exception {
                RemoteFileChannelInfo channel = service.prepareDownloadDocFile((Object)HelpAlgorithmVersionAction.this.versionInfo.getInfo().getId(), (Object)HelpAlgorithmVersionAction.this.versionInfo.getId(), filePath);
                RemoteFileInputStream stream = new RemoteFileInputStream(channel);
                this.setResult(stream);
            }
        };
        task.execute(this.window, null, filePath);
        Exception error = task.getError();
        if (error != null) {
            throw error;
        }
        if (task.wasCancelled()) {
            return null;
        }
        return (RemoteFileInputStream)task.getResult();
    }

    private boolean usesPDFViewer() {
        Configuration configuration;
        boolean defaultValue = false;
        ConfigurationManager confManager = ConfigurationManager.getInstance();
        try {
            configuration = confManager.getConfiguration(this.getClass());
        }
        catch (ConfigurationManagerException e) {
            return false;
        }
        String propName = "use.pdf.viewer";
        return configuration.getOptionalBooleanProperty("use.pdf.viewer", false);
    }

    public void hideIcon() {
        this.putValue("SmallIcon", null);
    }

    public void hideName() {
        this.putValue("Name", null);
    }

    public void setAlgorithmVersionInfo(AlgorithmVersionInfo versionInfo) {
        this.versionInfo = versionInfo;
        if (this.versionInfo == null) {
            this.setEnabled(false);
            return;
        }
        List documentation = this.versionInfo.getDocumentation();
        if (documentation == null || documentation.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        if (this.containsSinglePDFFile(documentation) && this.usesPDFViewer()) {
            this.setEnabled(true);
            return;
        }
        boolean hasHtmlFile = this.containsHtmlFile(documentation);
        ExternalResources extResources = ExternalResources.getInstance();
        boolean hasExtResources = extResources.isEnabled();
        if (documentation.size() == 1) {
            this.setEnabled(hasExtResources);
            return;
        }
        if (hasHtmlFile) {
            this.setEnabled(hasExtResources);
            return;
        }
    }

    private boolean containsHtmlFile(List<FileInfo> documentation) {
        for (FileInfo fileInfo : documentation) {
            if (!fileInfo.getName().equals("index.html")) continue;
            return true;
        }
        return false;
    }

    private boolean containsSinglePDFFile(List<FileInfo> documentation) {
        return documentation != null && documentation.size() == 1 && this.isResourcePDF(documentation.get(0).getName());
    }

    public void showIcon() {
        this.putValue("SmallIcon", ApplicationImages.ICON_HELP_24);
    }

    public void showName() {
        this.putValue("Name", LNG.get((String)"algorithms.help"));
    }

    private void showError(Throwable throwable) {
        StandardErrorDialogs.showErrorDialog(this.window, throwable);
    }

    private void showError(String message) {
        StandardErrorDialogs.showErrorDialog(this.window, message);
    }
}

