/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ParameterLoaderCommandListener;
import csbase.client.algorithms.parameters.ParameterLoaderView;
import csbase.client.desktop.CommandNotificationHandler;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.kernel.ClientException;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommandInfo;
import csbase.logic.CommandSubmission;
import csbase.logic.CommonClientProject;
import csbase.logic.Priority;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.ParameterLoader;
import csbase.remote.ClientRemoteLocator;
import java.awt.Window;
import java.util.Map;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;

public class ParameterLoaderCommandExecutionTask
extends RemoteTask<Boolean> {
    private final Window window;
    private final ParameterLoaderView parameterView;
    private boolean isExtractingParameters;
    private boolean success;
    private String cmdId;

    public ParameterLoaderCommandExecutionTask(Window window, ParameterLoaderView parameterView) {
        this.window = window;
        this.parameterView = parameterView;
        this.isExtractingParameters = false;
    }

    protected void cancelTask() {
        super.cancelTask();
        RemoteTask<Object> cancelTask = new RemoteTask<Object>(){

            protected void performTask() throws Exception {
                if (!ClientRemoteLocator.schedulerService.removeCommand((Object)ParameterLoaderCommandExecutionTask.this.cmdId)) {
                    ClientRemoteLocator.sgaService.killCommand(ParameterLoaderCommandExecutionTask.this.cmdId);
                }
            }
        };
        cancelTask.execute(this.window, LNG.get((String)"ParameterLoaderCommandExecutionTask.title"), LNG.get((String)"ParameterLoaderCommandExecutionTask.cancel.msg"));
    }

    protected void performTask() throws Exception {
        ParameterLoader parameterLoader = this.parameterView.getParameterLoader();
        Map<String, String> extractParametersValues = this.parameterView.getExtractParametersValues();
        this.isExtractingParameters = true;
        this.success = false;
        extractParametersValues.put(parameterLoader.getOutputParameterName(), this.parameterView.getOutputExtractFileName());
        String algoName = parameterLoader.getAlgorithmName();
        AlgorithmVersionId versionId = parameterLoader.getAlgorithmVersionId();
        AlgorithmConfigurator extractConfigurator = ClientRemoteLocator.algorithmService.createAlgorithmConfigurator(algoName, versionId);
        extractConfigurator.setParameterValuesByName(extractParametersValues);
        CommonClientProject project = DesktopFrame.getInstance().getProject();
        CommandSubmission submission = new CommandSubmission(extractConfigurator, project.getId());
        submission.setPriority(Priority.ROOT);
        submission.setDescription("Extrator de Par\u00e2metros");
        ExecutionType type = extractConfigurator.getExecutionType();
        if (type != ExecutionType.SIMPLE) {
            throw new ClientException(String.format(LNG.get((String)"ParameterLoaderCommandExecutionTask.error.execution.type"), type));
        }
        Set commands = ClientRemoteLocator.schedulerService.submitCommand(submission);
        if (commands == null) {
            throw new ClientException(LNG.get((String)"ParameterLoaderCommandExecutionTask.error.submit"));
        }
        CommandInfo command = (CommandInfo)commands.iterator().next();
        this.cmdId = command.getId();
        CommandNotificationHandler.getInstance().addListener(new ParameterLoaderCommandListener(this, this.cmdId));
        while (this.isExtractingParameters) {
            Thread.sleep(5000L);
        }
        this.setResult(this.success);
    }

    @Override
    protected void handleError(Exception error) {
        if (error instanceof ClientException) {
            StandardErrorDialogs.showErrorDialog(this.window, LNG.get((String)"ParameterLoaderCommandExecutionTask.title"), error.getMessage());
        } else {
            super.handleError(error);
        }
    }

    public void executionCompleted(boolean wasSuccessful) {
        this.isExtractingParameters = false;
        this.success = wasSuccessful;
    }
}

