/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import csbase.client.applications.flowapplication.graph.FileTypeColorManager;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphElementListener;
import csbase.client.applications.flowapplication.graph.GraphLink;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.Grid;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.FileParameterListener;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.SimpleParameterListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.vix.TypeVO;
import tecgraf.vix.TypeVS;
import tecgraf.vix.VO;

public final class GraphFileDescriptor
extends VO {
    private static final Color BORDER_COLOR = Color.BLACK;
    private static final Color DISABLED_COLOR = Color.LIGHT_GRAY;
    private static final Color ERROR_COLOR = Color.RED;
    private static final Color EMPTY_BACKGROUND_COLOR = Color.WHITE;
    private static final Color DIRECTORY_TYPE_COLOR = Color.BLUE;
    private static final int HEIGHT = 6;
    private static final Color HIGHLIGHTED_COLOR = GraphElement.HIGHT_LIGHT_COLOR;
    private static final int HORIZONTAL_MARGIN = 2;
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Stroke THICKER_STROKE = new BasicStroke(2.0f);
    private static final int VERTICAL_MARGIN = 2;
    private static final int WIDTH = 12;
    private static final Color BYPASSED_COLOR = new Color(150, 150, 150);
    private Color backgroundColor;
    private Color borderColor;
    private Color defaultColor;
    private Stroke stroke;
    private FileParameter fileParameter;
    private boolean isInput;
    private boolean isOutput;
    private final Set<GraphLink> linkFromSet;
    private GraphLink linkTo;
    private final String parameterLabel;
    private final String parameterName;
    private GeneralPath path;
    private boolean isVisible;

    public GraphFileDescriptor(String parameterName, String parameterLabel, boolean isOutput, GraphNode node) {
        if (parameterName == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterName est\u00e1 nulo.");
        }
        if (parameterLabel == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterLabel est\u00e1 nulo.");
        }
        if (node == null) {
            throw new IllegalArgumentException("O par\u00e2metro node est\u00e1 nulo.");
        }
        this.isOutput = isOutput;
        this.isInput = !isOutput;
        this.parameterName = parameterName;
        this.parameterLabel = parameterLabel;
        this.linkFromSet = new HashSet<GraphLink>();
        this.createDefaultColor();
        this.updateColor();
        this.changeVS(null, (TypeVS)node);
        this.createShape(new Point());
        node.addListener(new NodeListener());
        this.updateVisibility();
    }

    public GraphFileDescriptor(FileParameter fileParameter, GraphNode node) {
        if (fileParameter == null) {
            throw new IllegalArgumentException("O par\u00e2metro fileParameter est\u00e1 nulo.");
        }
        if (node == null) {
            throw new IllegalArgumentException("O par\u00e2metro node est\u00e1 nulo.");
        }
        this.fileParameter = fileParameter;
        if (this.fileParameter instanceof OutputFileParameter) {
            this.isOutput = true;
        } else if (this.fileParameter instanceof InputFileParameter) {
            this.isInput = true;
        } else {
            throw new IllegalArgumentException(MessageFormat.format("O par\u00e2metro {0} \u00e9 de uma classe inesperada ({1}).", this.fileParameter, this.fileParameter.getClass().getName()));
        }
        this.parameterName = this.fileParameter.getName();
        this.parameterLabel = this.fileParameter.getLabel();
        this.fileParameter.addFileParameterListener(new FileParameterListener(){

            public void hasLinkWasChanged(FileParameter parameter) {
            }

            public void typeWasChanged(FileParameter parameter) {
                GraphFileDescriptor.this.createDefaultColor();
                GraphFileDescriptor.this.updateColor();
                GraphFileDescriptor.this.vs.repaint();
            }
        });
        this.fileParameter.addSimpleParameterListener((SimpleParameterListener)new SimpleParameterListener<FileParameterValue>(){

            public void capabilityWasChanged(SimpleParameter<FileParameterValue> parameter) {
            }

            public void defaultValueWasChanged(SimpleParameter<FileParameterValue> parameter) {
            }

            public void labelWasChanged(SimpleParameter<FileParameterValue> parameter) {
            }

            public void valueWasChanged(SimpleParameter<FileParameterValue> parameter) {
                GraphFileDescriptor.this.updateVisibility();
            }

            public void visibilityWasChanged(SimpleParameter<FileParameterValue> parameter) {
            }
        });
        this.linkFromSet = new HashSet<GraphLink>();
        this.createDefaultColor();
        this.updateColor();
        this.changeVS(null, (TypeVS)node);
        this.createShape(new Point());
        node.addListener(new NodeListener());
        this.updateVisibility();
    }

    public void callbackRepaint(Graphics2D g) {
        if (this.isVisible()) {
            g.setPaint(this.backgroundColor);
            g.fill(this.path);
            g.setPaint(this.borderColor);
            g.setStroke(this.stroke);
            g.draw(this.path);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        GraphFileDescriptor graphFileType = (GraphFileDescriptor)((Object)obj);
        if (!this.getParameterName().equals(graphFileType.getParameterName())) {
            return false;
        }
        if (!this.vs.equals(graphFileType.vs)) {
            return false;
        }
        return super.equals(obj);
    }

    public Rectangle2D getBounds2D() {
        Rectangle2D bounds = this.path.getBounds2D();
        bounds.setFrameFromDiagonal(bounds.getMinX() - 2.0, bounds.getMinY() - 2.0, bounds.getMaxX() + 2.0, bounds.getMaxY() + 2.0);
        return bounds;
    }

    public FileParameter getFileParameter() {
        return this.fileParameter;
    }

    public Collection<GraphLink> getLinkFromCollection() {
        return Collections.unmodifiableCollection(this.linkFromSet);
    }

    public GraphLink getLinkTo() {
        return this.linkTo;
    }

    public GraphNode getNode() {
        return (GraphNode)this.vs;
    }

    public String getParameterLabel() {
        return this.parameterLabel;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public int hashCode() {
        return this.vs.hashCode();
    }

    public boolean isInput() {
        return this.isInput;
    }

    public boolean isOutput() {
        return this.isOutput;
    }

    public boolean validate() {
        if (!this.isWellFormed()) {
            return false;
        }
        return !this.isVisible || !this.fileParameter.isEnabled() || this.fileParameter.isOptional() || this.fileParameter.usesPipe() != FileParameterPipeAcceptance.ALWAYS || !(this.isInput ? this.getLinkTo() == null : this.isOutput && this.getLinkFromCollection().isEmpty());
    }

    public boolean isWellFormed() {
        if (this.fileParameter == null) {
            return false;
        }
        if (!this.isVisible) {
            if (this.getLinkTo() != null) {
                return false;
            }
            if (!this.getLinkFromCollection().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public boolean isVisible() {
        return this.isVisible || !this.isWellFormed();
    }

    public String toString() {
        String fileType = null;
        if (this.getFileParameter() != null) {
            fileType = this.getFileParameter().getFileType();
        }
        if (fileType == null) {
            fileType = LNG.get((String)(GraphFileDescriptor.class.getName() + ".unknownFileType"));
        }
        return this.getParameterLabel() + " (" + fileType + ")";
    }

    public TypeVO pick(Point2D pt) {
        if (!this.isVisible()) {
            return null;
        }
        return super.pick(pt);
    }

    void addLinkFrom(GraphLink link) {
        this.linkFromSet.add(link);
        if (this.getFileParameter() != null) {
            this.getFileParameter().setHasLink(true);
        }
    }

    boolean contains(Point2D point) {
        return this.getBounds2D().contains(point);
    }

    String getHint() {
        return this.toString();
    }

    Point2D getLinkablePoint() {
        Rectangle2D bounds = this.path.getBounds2D();
        Point point = new Point();
        double y = this.isOutput() ? bounds.getMaxY() : bounds.getMinY();
        ((Point2D)point).setLocation(bounds.getCenterX(), y);
        return point;
    }

    void removeLinkFrom(GraphLink link) {
        this.linkFromSet.remove((Object)link);
        if (this.linkFromSet.isEmpty() && this.getFileParameter() != null) {
            this.getFileParameter().setHasLink(false);
        }
    }

    void setLinkTo(GraphLink link) {
        this.linkTo = link;
        if (this.linkTo != null) {
            if (this.getFileParameter() != null) {
                this.getFileParameter().setHasLink(true);
            }
        } else if (this.getFileParameter() != null) {
            this.getFileParameter().setHasLink(false);
        }
    }

    void setLocation(Point2D pt) {
        this.createShape(pt);
        this.updateLinks();
        this.updateColor();
    }

    void adjustGrid() {
        Rectangle2D bounds2d = this.path.getBounds2D();
        double centerX = bounds2d.getCenterX();
        double centerY = bounds2d.getCenterY();
        Point2D newPoint = Grid.adjustPoint(new Point2D.Double(centerX, centerY));
        this.setLocation(newPoint);
    }

    void turnOffHightLight() {
        this.updateColor();
    }

    void turnOnHightLight() {
        this.borderColor = this.backgroundColor = HIGHLIGHTED_COLOR;
    }

    private void createDefaultColor() {
        FileTypeColorManager fileTypeManager;
        this.defaultColor = !this.isWellFormed() ? Color.RED : (this.fileParameter.getMode() == FileParameterMode.DIRECTORY ? DIRECTORY_TYPE_COLOR : ((fileTypeManager = FileTypeColorManager.getInstance()) == null ? Color.BLACK : fileTypeManager.getColor(this.fileParameter.getFileType())));
    }

    private void createShape(Point2D point) {
        float centerX = (float)point.getX();
        float lowerY = (float)point.getY();
        if (this.isOutput()) {
            lowerY += 6.0f;
        }
        float x = centerX - 6.0f;
        float y = lowerY - 6.0f;
        this.path = new GeneralPath();
        this.path.moveTo(x + 6.0f, y + 6.0f);
        this.path.lineTo(x + 12.0f, y);
        this.path.lineTo(x, y);
        this.path.closePath();
    }

    private void updateColor() {
        this.stroke = DEFAULT_STROKE;
        if (!this.isWellFormed()) {
            this.backgroundColor = ERROR_COLOR;
            this.borderColor = ERROR_COLOR;
        } else if (this.isBypassed()) {
            this.backgroundColor = BYPASSED_COLOR;
            this.borderColor = BYPASSED_COLOR;
        } else if (this.getFileParameter().isEnabled()) {
            if (this.fileParameter.usesPipe() == FileParameterPipeAcceptance.ALWAYS) {
                this.borderColor = this.defaultColor;
                this.backgroundColor = EMPTY_BACKGROUND_COLOR;
                this.stroke = THICKER_STROKE;
            } else {
                this.backgroundColor = this.defaultColor;
                this.borderColor = BORDER_COLOR;
            }
        } else {
            this.backgroundColor = DISABLED_COLOR;
            this.borderColor = DISABLED_COLOR;
        }
    }

    private boolean isBypassed() {
        GraphNode node = this.getNode();
        if (node != null) {
            return node.isBypassed();
        }
        return false;
    }

    private void updateVisibility() {
        if (this.fileParameter != null) {
            switch (this.fileParameter.usesPipe()) {
                case ALWAYS: {
                    this.isVisible = this.fileParameter.isVisible();
                    break;
                }
                case FALSE: {
                    this.isVisible = false;
                    break;
                }
                default: {
                    if (this.fileParameter.getValue() != null) {
                        this.isVisible = false;
                        break;
                    }
                    this.isVisible = this.fileParameter.isVisible();
                    break;
                }
            }
        } else {
            this.isVisible = true;
        }
        this.updateColor();
    }

    private void updateLinks() {
        if (this.linkTo != null) {
            this.linkTo.updateEndPoint();
        } else {
            for (GraphLink link : this.linkFromSet) {
                link.updateStartPoint();
            }
        }
    }

    private final class NodeListener
    implements GraphElementListener {
        private NodeListener() {
        }

        @Override
        public void wasAnchored(GraphLink link, GraphFileDescriptor fd) {
            GraphFileDescriptor.this.updateColor();
        }

        @Override
        public void wasDragged(GraphElement element, Point2D startPoint, Point2D endPoint) {
        }

        @Override
        public void wasDragged(GraphElement element, double tx, double ty) {
        }

        @Override
        public void wasDropped(GraphElement element, Point2D point) {
        }

        @Override
        public void wasIncreased(GraphLink link) {
        }

        @Override
        public void wasParameterSetVisible(GraphNode node, String paramName, boolean visible) {
            GraphFileDescriptor.this.updateVisibility();
            GraphFileDescriptor.this.vs.repaint();
        }

        @Override
        public void wasParameterSetEnabled(GraphNode n, String paramName, boolean isEnabled) {
            GraphFileDescriptor.this.updateColor();
        }

        @Override
        public void wasParametrized(GraphElement element) {
        }

        @Override
        public void wasLinkStatusChanged(GraphLink link) {
        }

        @Override
        public void wasRenamed(GraphNode node) {
        }

        @Override
        public void wasResized(GraphNode n) {
        }

        @Override
        public void wasSelected(GraphElement element) {
        }

        @Override
        public void wasUnanchored(GraphLink link, GraphFileDescriptor fd) {
            GraphFileDescriptor.this.updateColor();
        }
    }
}

