/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.MultipleProjectSpaceTask;
import csbase.client.applications.projectsmanager.proxy.ReloadSelectedProjectsTask;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.StandardDialogs;

public class RefreshProjectsAction
extends ProjectsManagerAction {
    public RefreshProjectsAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void actionDone() {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() <= 0) {
            return;
        }
        ArrayList<String> projectNames = new ArrayList<String>();
        ArrayList<Object> ownerId = new ArrayList<Object>();
        for (ProjectsManagerData pmd : projectList) {
            projectNames.add(pmd.getProjectName());
            ownerId.add(pmd.getOwnerId());
        }
        List<Double> occupiedSpaces = this.runMultipleProjectSpaceTask(projectNames, ownerId);
        List<ProjectsManagerData> updatedProjectList = this.runUpdateProjectDataTask(projectList);
        int count = 0;
        for (ProjectsManagerData pmd : updatedProjectList) {
            Double occupiedSpace = occupiedSpaces.get(count);
            if (occupiedSpace.doubleValue() != pmd.getOccupiedSpace()) {
                pmd.setOccupiedSpace(occupiedSpace);
                projectsManager.updateProjectOccupiedSpace(pmd);
            }
            ++count;
        }
        projectsManager.refreshProjectsTable();
    }

    private List<ProjectsManagerData> runUpdateProjectDataTask(List<ProjectsManagerData> projectList) {
        ProjectsManager projectsManager = this.getProjectsManager();
        ReloadSelectedProjectsTask rspt = new ReloadSelectedProjectsTask(projectsManager, projectList);
        rspt.execute(projectsManager.getApplicationFrame(), this.getString("RefreshProjectsAction.title"), this.getString("RefreshProjectsAction.message"));
        if (rspt.wasCancelled()) {
            String err = this.getString("RefreshProjectsAction.cancelled.message");
            rspt.showError(err);
            return null;
        }
        if (!rspt.getStatus()) {
            Exception exception = rspt.getError();
            ProjectsManagerUI.handleException(this.getProjectsManager(), exception);
            return null;
        }
        List updatedProjectList = (List)rspt.getResult();
        if (updatedProjectList == null) {
            String errTitle = this.getString("RefreshProjectsAction.modification.date.title");
            String errMsg = this.getString("RefreshProjectsAction.modification.date.message");
            StandardDialogs.showErrorDialog((Component)this.getProjectsManager().getApplicationFrame(), (String)errTitle, (String)errMsg);
            return null;
        }
        return updatedProjectList;
    }

    private List<Double> runMultipleProjectSpaceTask(List<String> projectNames, List<Object> ownerId) {
        ProjectsManager projectsManager = this.getProjectsManager();
        MultipleProjectSpaceTask spst = new MultipleProjectSpaceTask(projectsManager, projectNames, ownerId);
        spst.execute(projectsManager.getApplicationFrame(), this.getString("RefreshProjectsAction.title"), this.getString("RefreshProjectsAction.message"));
        if (spst.wasCancelled()) {
            String err = this.getString("RefreshProjectsAction.cancelled.message");
            spst.showError(err);
            return null;
        }
        if (!spst.getStatus()) {
            Exception exception = spst.getError();
            ProjectsManagerUI.handleException(this.getProjectsManager(), exception);
            return null;
        }
        List occupiedSpace = (List)spst.getResult();
        if (occupiedSpace == null) {
            String errTitle = this.getString("RefreshProjectsAction.occupied.space.error.title");
            String errMsg = this.getString("RefreshProjectsAction.occupied.space.error.message");
            StandardDialogs.showErrorDialog((Component)this.getProjectsManager().getApplicationFrame(), (String)errTitle, (String)errMsg);
            return null;
        }
        return occupiedSpace;
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ApplicationImages.ICON_REFRESH_ONE_16;
    }
}

