/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectPermissions;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.util.Set;

class ReplicateSharingDataTask
extends ProjectsManagerTask<Void> {
    private final ProjectsManagerData sourceProject;
    private final Set<ProjectsManagerData> targetProjects;

    public ReplicateSharingDataTask(ProjectsManager projectsManager, ProjectsManagerData sourceProject, Set<ProjectsManagerData> targetProjects) {
        super(projectsManager);
        this.sourceProject = sourceProject;
        this.targetProjects = targetProjects;
    }

    protected void performTask() throws Exception {
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        CommonClientProject sourceCCP = psi.openProject(this.sourceProject.getProjectId(), false);
        Set usersRO = sourceCCP.getUsersRO();
        Set usersRW = sourceCCP.getUsersRW();
        ProjectPermissions.SharingType sharingType = sourceCCP.getSharingType();
        sourceCCP.close(false);
        for (ProjectsManagerData pmd : this.targetProjects) {
            CommonClientProject targetCCP = psi.openProject(pmd.getProjectId(), true);
            targetCCP.updateUsers(sharingType, usersRO, usersRW);
            targetCCP.close(true);
        }
    }
}

