/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.dialogs;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.dialogs.UserSpaceModel;
import csbase.client.applications.projectsmanager.dialogs.core.ProjectsManagerDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpecificAreaOccupationData;
import csbase.client.applications.projectsmanager.panels.renderers.TableOccupationRenderer;
import csbase.client.applications.projectsmanager.proxy.GetSpecificSpaceUsageTask;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.table.SortableTable;

public class ProjectOccupationDialog
extends ProjectsManagerDialog {
    private final SortableTable userSpaceTable = new SortableTable();

    private JPanel buildButtonsPanel() {
        JButton closeButton = new JButton();
        JButton refreshButton = new JButton();
        refreshButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectOccupationDialog.this.refreshData();
            }
        });
        refreshButton.setText(this.getString("ProjectOccupationDialog.refresh.button"));
        final ProjectOccupationDialog pod = this;
        closeButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pod.dispose();
            }
        });
        closeButton.setText(this.getString("ProjectOccupationDialog.close.button"));
        JComponent[] buttons = new JComponent[]{refreshButton, closeButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(refreshButton);
        buttonsPanel.add(closeButton);
        return buttonsPanel;
    }

    private void initTable() {
        this.userSpaceTable.setModel((TableModel)new UserSpaceModel());
        this.userSpaceTable.setNoSortStateEnabled(true);
        TableColumnModel columnModel = this.userSpaceTable.getColumnModel();
        TableColumn column2 = columnModel.getColumn(2);
        column2.setCellRenderer(new TableOccupationRenderer());
        JTableHeader header = this.userSpaceTable.getTableHeader();
        TableColumnModel tcm = header.getColumnModel();
        TableColumn c0 = tcm.getColumn(0);
        TableColumn c1 = tcm.getColumn(1);
        TableColumn c2 = tcm.getColumn(2);
        c0.setPreferredWidth(50);
        c1.setPreferredWidth(250);
        c2.setPreferredWidth(150);
        c0.setHeaderValue(this.getString("ProjectOccupationDialog.login.header"));
        c1.setHeaderValue(this.getString("ProjectOccupationDialog.name.header"));
        c2.setHeaderValue(this.getString("ProjectOccupationDialog.space.header"));
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        JScrollPane userSpaceTablePane = this.buildListPanel();
        JPanel buttonsPanel = this.buildButtonsPanel();
        this.add((Component)userSpaceTablePane, new GBC(0, 0).both());
        this.add((Component)buttonsPanel, new GBC(0, 1).horizontal());
    }

    private JScrollPane buildListPanel() {
        JScrollPane userSpaceTablePane = new JScrollPane((Component)this.userSpaceTable);
        JPanel specificPanel = new JPanel(new GridBagLayout());
        specificPanel.add((Component)userSpaceTablePane, new GBC(0, 0).both());
        String title = this.getString("ProjectOccupationDialog.occupation.frame");
        BorderUtil.setTitledBorder((JComponent)specificPanel, (String)title);
        return userSpaceTablePane;
    }

    private void refreshData() {
        ProjectsManager projectsManager = this.getProjectsManager();
        GetSpecificSpaceUsageTask gssut = new GetSpecificSpaceUsageTask(projectsManager);
        ApplicationFrame appFrame = projectsManager.getApplicationFrame();
        String title = this.getString("ProjectOccupationDialog.task.title");
        String msg = this.getString("ProjectOccupationDialog.task.message");
        gssut.execute(appFrame, title, msg);
        if (gssut.wasCancelled()) {
            String err = this.getString("ProjectOccupationDialog.task.cancelled.message");
            gssut.showError(err);
            return;
        }
        if (!gssut.getStatus()) {
            Exception exception = gssut.getError();
            projectsManager.showExceptionStack(exception);
            return;
        }
        ProjectSpecificAreaOccupationData paod = (ProjectSpecificAreaOccupationData)gssut.getResult();
        ((UserSpaceModel)this.userSpaceTable.getModel()).setData(paod);
    }

    public ProjectOccupationDialog(ProjectsManager projectsManager) {
        super(projectsManager);
        this.initTable();
        this.initPanel();
        this.refreshData();
    }
}

