/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.DesktopWindowInterface;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import tecgraf.javautils.gui.GUIUtils;

public class DesktopComponentDialog
extends JDialog
implements DesktopWindowInterface {
    private void build() {
        this.setDefaultCloseOperation(0);
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        if (desktopFrame != null) {
            desktopFrame.addWindow(this);
        }
    }

    public void center() {
        this.center(this.getOwner());
    }

    public void center(Window window) {
        int minY;
        JFrame jframe;
        int windowState;
        if (window == null) {
            GUIUtils.centerOnScreen((Window)this);
            return;
        }
        if (window instanceof JFrame && ((windowState = (jframe = (JFrame)window).getExtendedState()) & 6) != 0) {
            GUIUtils.centerOnScreen((Window)this);
            return;
        }
        Dimension currentSize = this.getSize();
        Dimension windowSize = window.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int minX = window.getX() + (windowSize.width - currentSize.width) / 2;
        if (minX + currentSize.width > screenSize.width) {
            minX = screenSize.width - currentSize.width;
        }
        if (minX < 0) {
            minX = 0;
        }
        if ((minY = window.getY() + (windowSize.height - currentSize.height) / 2) + currentSize.height > screenSize.height) {
            minY = screenSize.height - currentSize.height;
        }
        if (minY < 0) {
            minY = 0;
        }
        this.setLocation(minX, minY);
    }

    @Override
    public void close() {
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        if (desktopFrame != null) {
            desktopFrame.removeWindow(this);
        }
        this.dispose();
    }

    public DesktopComponentDialog(Window owner) {
        this(owner, (String)null);
    }

    public DesktopComponentDialog(Window owner, String title) {
        super((Window)(owner == null ? (DesktopFrame.getInstance() == null ? null : DesktopFrame.getInstance().getDesktopFrame()) : owner), title, Dialog.DEFAULT_MODALITY_TYPE);
        this.build();
    }
}

