/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.project.ProjectTreeNode;
import csbase.client.project.ProjectTreeStructureListener;
import csbase.logic.ClientProjectFile;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;

final class ProjectTreeStructureListenerImpl
implements ProjectTreeStructureListener {
    private final JTree tree;
    private Stack<ChangeData> stack;

    ProjectTreeStructureListenerImpl(JTree projectTree) {
        this.tree = projectTree;
        this.stack = new Stack();
    }

    @Override
    public void treeWillChange(TreeModelEvent event) {
        ChangeData data = new ChangeData();
        this.saveExpandedPaths(data);
        this.saveSelectionPaths(data);
        this.saveVisibleArea(data);
        this.stack.push(data);
    }

    private void saveExpandedPaths(ChangeData data) {
        ProjectTreeNode rootNode = (ProjectTreeNode)this.tree.getModel().getRoot();
        if (rootNode == null) {
            return;
        }
        Enumeration<TreePath> treePaths = this.tree.getExpandedDescendants(rootNode.getTreePath());
        if (treePaths == null) {
            return;
        }
        while (treePaths.hasMoreElements()) {
            TreePath treePath = treePaths.nextElement();
            ProjectTreeNode node = (ProjectTreeNode)treePath.getLastPathComponent();
            ClientProjectFile cpf = node.getClientProjectFile();
            data.expandedPaths.add(cpf.getPath());
        }
    }

    private void saveSelectionPaths(ChangeData data) {
        data.selectedPaths.clear();
        TreePath[] treePaths = this.tree.getSelectionPaths();
        if (treePaths == null) {
            return;
        }
        for (TreePath treePath : treePaths) {
            ProjectTreeNode node = (ProjectTreeNode)treePath.getLastPathComponent();
            ClientProjectFile cpf = node.getClientProjectFile();
            data.selectedPaths.add(cpf.getPath());
        }
    }

    private void saveVisibleArea(ChangeData data) {
        data.visibleRectangle = this.tree.getVisibleRect();
    }

    @Override
    public void treeWasChanged(TreeModelEvent event) {
        if (this.stack.isEmpty()) {
            return;
        }
        ChangeData data = this.stack.pop();
        this.restoreExpandPaths(data);
        this.restoreSelectPaths(data);
        this.restoreVisibleArea(data);
    }

    private void restoreExpandPaths(ChangeData data) {
        ProjectTreeNode rootNode = (ProjectTreeNode)this.tree.getModel().getRoot();
        if (rootNode == null) {
            return;
        }
        for (String[] path : data.expandedPaths) {
            ProjectTreeNode node = rootNode;
            for (int i = 0; i < path.length && node != null; node = node.getChild(path[i]), ++i) {
            }
            if (node == null || !this.tree.isCollapsed(node.getTreePath())) continue;
            this.tree.expandPath(node.getTreePath());
        }
    }

    private void restoreSelectPaths(ChangeData data) {
        ProjectTreeNode rootNode = (ProjectTreeNode)this.tree.getModel().getRoot();
        if (rootNode == null) {
            return;
        }
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        for (String[] path : data.selectedPaths) {
            ProjectTreeNode node = rootNode;
            for (int i = 0; i < path.length && node != null; node = node.getChild(path[i]), ++i) {
            }
            if (node == null) continue;
            treePaths.add(node.getTreePath());
        }
        this.tree.setSelectionPaths(treePaths.toArray(new TreePath[0]));
    }

    private void restoreVisibleArea(ChangeData data) {
        this.tree.scrollRectToVisible(data.visibleRectangle);
    }

    private static class ChangeData {
        List<String[]> expandedPaths = new ArrayList<String[]>();
        List<String[]> selectedPaths = new ArrayList<String[]>();
        Rectangle visibleRectangle;

        private ChangeData() {
        }
    }
}

